/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Record
implements Serializable {
    private static final long serialVersionUID = 3125441062003682173L;
    private boolean parsed;
    private String originContent;
    private String badCause;
    private long characterPosition;
    private List<Object> values;
    boolean hasGeometryField;

    public Record(String origin, List<?> values, String badCause) {
        this.parsed = false;
        this.badCause = badCause;
        this.values = values;
        this.originContent = origin;
    }

    public Record(String sql, long characterPosition) {
        this.parsed = true;
        this.originContent = sql;
        this.characterPosition = characterPosition;
    }

    public Record(List<?> values) {
        this.parsed = true;
        this.values = values;
    }

    public Record(String[] values) {
        this.parsed = true;
        this.values = values != null ? Lists.newArrayList((Object[])values) : new ArrayList();
    }

    public Record(List<?> values, long characterPosition) {
        this.parsed = true;
        this.characterPosition = characterPosition;
        this.values = values != null ? values : new ArrayList(0);
    }

    public int size() {
        return this.isValid() ? this.values.size() : 0;
    }

    public Object get(int index) {
        return this.isValid() ? this.values.get(index) : null;
    }

    public String getString(int index) {
        if (this.isValid()) {
            Object obj = this.values.get(index);
            return obj != null ? obj.toString() : null;
        }
        return null;
    }

    public boolean isValid() {
        return this.parsed && CollectionUtils.isNotEmpty(this.values);
    }

    public void add(Object value) {
        this.values.add(value);
    }

    public void replaceAll(List<Object> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void replace(int index, String replacer) {
        this.values.set(index, replacer);
    }

    public void remove(int index) {
        this.values.remove(index);
    }

    public List<?> getValues(Collection<Integer> indexes) {
        return indexes.stream().map(this::get).collect(Collectors.toList());
    }

    public List<String> getStringValues() {
        return this.values.stream().map(e -> e != null ? e.toString() : null).collect(Collectors.toList());
    }

    public void clearAll() {
        if (this.values != null) {
            this.values.clear();
            this.values = null;
        }
    }

    public int getByteSize(String charset) {
        if (CollectionUtils.isEmpty(this.values)) {
            return 0;
        }
        String cs = StringUtils.isBlank((CharSequence)charset) ? "UTF-8" : charset;
        int total = this.values.size() * 2 + 4;
        for (Object obj : this.values) {
            String value = obj != null ? obj.toString() : null;
            try {
                total += value == null ? 1 : value.getBytes(cs).length;
            }
            catch (Exception e) {
                total += (int)((double)value.length() * 1.5);
            }
        }
        return total;
    }

    public String toString() {
        if (CollectionUtils.isEmpty(this.values)) {
            return "Null Record";
        }
        StringJoiner joiner = new StringJoiner(",");
        for (Object obj : this.values) {
            joiner.add(obj != null ? obj.toString() : null);
        }
        return joiner.toString();
    }

    public String toValueClause() {
        return "VALUES (" + this.values.stream().map(e -> e == null ? "null" : "'" + e + "'").collect(Collectors.joining(",")) + ");";
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public String getOriginContent() {
        return this.originContent;
    }

    public String getBadCause() {
        return this.badCause;
    }

    public long getCharacterPosition() {
        return this.characterPosition;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public boolean isHasGeometryField() {
        return this.hasGeometryField;
    }

    public void setParsed(boolean parsed) {
        this.parsed = parsed;
    }

    public void setOriginContent(String originContent) {
        this.originContent = originContent;
    }

    public void setBadCause(String badCause) {
        this.badCause = badCause;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public void setHasGeometryField(boolean hasGeometryField) {
        this.hasGeometryField = hasGeometryField;
    }
}

