/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.loader.PrepareStatementValueSetter;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;

public class SqlContext {
    private String sql;
    private int count;
    private boolean completed;
    private List<List<Object>> batchArgs;
    private List<PrepareStatementValueSetter> psStmtSetters;

    public SqlContext(@NonNull String sql, int count, List<List<Object>> batchArgs, @NonNull List<PrepareStatementValueSetter> psStmtSetters, boolean completed) {
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
        if (psStmtSetters == null) {
            throw new NullPointerException("psStmtSetters is marked non-null but is null");
        }
        this.sql = sql;
        this.count = count;
        this.batchArgs = batchArgs;
        this.completed = completed;
        this.psStmtSetters = psStmtSetters;
    }

    public void clearAll() {
        this.sql = null;
        this.count = 0;
        this.completed = true;
        if (this.psStmtSetters != null) {
            this.psStmtSetters.clear();
            this.psStmtSetters = null;
        }
        if (this.batchArgs != null) {
            for (List<Object> args : this.batchArgs) {
                args.clear();
                Object var2_2 = null;
            }
            this.batchArgs.clear();
            this.batchArgs = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlContext that = (SqlContext)o;
        return this.count == that.count && this.completed == that.completed && Objects.equals(this.sql, that.sql) && ArrayUtils.isEquals(this.batchArgs, that.batchArgs);
    }

    public int hashCode() {
        return Objects.hash(this.sql, this.count, this.completed, this.batchArgs);
    }

    public String getSql() {
        return this.sql;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public List<List<Object>> getBatchArgs() {
        return this.batchArgs;
    }

    public List<PrepareStatementValueSetter> getPsStmtSetters() {
        return this.psStmtSetters;
    }
}

