/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.SourceType;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.parser.record.AbstractRecordParser;
import com.oceanbase.tools.loaddump.parser.record.avro.AvroRecordParser;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import com.oceanbase.tools.loaddump.parser.record.cut.CutRecordParserV2;
import com.oceanbase.tools.loaddump.parser.record.orc.OrcRecordParserV2;
import com.oceanbase.tools.loaddump.parser.record.par.ParquetRecordParserV2;
import com.oceanbase.tools.loaddump.parser.record.pos.Offset;
import com.oceanbase.tools.loaddump.parser.record.pos.PosRecordParser;
import com.oceanbase.tools.loaddump.parser.record.sql.SqlRecordParser;
import com.oceanbase.tools.loaddump.resource.ResourceV2;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.orc.StripeInformation;

public class SubFile
implements Comparable<SubFile>,
Serializable {
    private static final long serialVersionUID = -5733534638186630854L;
    private int uid;
    private final AtomicLong parsedCount = new AtomicLong(0L);
    private final AtomicLong loadedCount = new AtomicLong(0L);
    private final AtomicLong loadedBytes = new AtomicLong(0L);
    private final AtomicLong errorCounts = new AtomicLong(0L);
    private List<String> headers;
    private int index;
    private long offset;
    private long totalSize;
    private String message;
    private String schemaName;
    private String objectName;
    private String objectType;
    private long partitionId;
    private String filePath;
    private ResourceV2 resource;
    private DataFormat dataFormat;
    private TaskDetail taskDetail;
    private boolean visited;
    private int retryOffset = 0;
    private boolean skipHeader;
    private boolean skipFooter;
    private volatile TaskState taskState = TaskState.INITIAL;
    private List<String> parentDirNames;
    private List<StripeInformation> stripes;

    public SubFile() {
    }

    public SubFile(ResourceV2 resource, DataFormat format) {
        this(resource, 0, 0L, resource.getTotalSize(), format, null);
    }

    public SubFile(ResourceV2 resource, int index, long startPos, long endPos, DataFormat dataFormat) {
        this(resource, index, startPos, endPos, dataFormat, null);
    }

    public SubFile(ResourceV2 resource, int index, List<StripeInformation> stripes) {
        this(resource, index, 0L, stripes.stream().mapToLong(StripeInformation::getLength).sum(), DataFormat.ORC, null, stripes);
    }

    public SubFile(ResourceV2 resource, int index, long startPos, long endPos, DataFormat dataFormat, List<String> parentDirNames) {
        this(resource, index, startPos, endPos, dataFormat, parentDirNames, null);
    }

    private SubFile(ResourceV2 resource, int index, long startPos, long endPos, DataFormat dataFormat, List<String> parentDirNames, List<StripeInformation> stripes) {
        this.stripes = stripes;
        this.resource = resource;
        this.dataFormat = dataFormat;
        this.index = index;
        this.offset = startPos;
        this.totalSize = endPos - startPos;
        this.objectType = resource.getObjectType();
        this.filePath = resource.getPath();
        this.objectName = resource.getObjectName();
        this.parentDirNames = parentDirNames;
    }

    public InputStream openBoundedStream(String fileEncoding) throws Exception {
        boolean decompress = this.dataFormat != DataFormat.MIX && this.dataFormat != DataFormat.DDL;
        return this.resource.openBoundedInputStream(fileEncoding, this.offset, this.totalSize, decompress);
    }

    public AbstractRecordParser createRecordParser(LoadParameter parameter) throws Exception {
        String urlFilePath;
        InputStream stream;
        String fileEncoding = parameter.getFileEncoding();
        StorageConfig storageConfig = parameter.getStorageConfig();
        Configuration configuration = storageConfig.getFsConf();
        ArrayList<String> extraColumnNames = null;
        ArrayList<String> extraColumnValues = null;
        boolean isExtraColumnPartition = false;
        if (SourceType.supportsDirNameAsPartitionValue(parameter.getSourceType()) && CollectionUtils.isNotEmpty(this.parentDirNames)) {
            extraColumnNames = new ArrayList<String>(this.parentDirNames.size());
            extraColumnValues = new ArrayList<String>(this.parentDirNames.size());
            for (String parentDirName : this.parentDirNames) {
                String[] split = parentDirName.split("=");
                if (split.length != 2) continue;
                extraColumnNames.add(split[0]);
                extraColumnValues.add(split[1]);
            }
            if (CollectionUtils.isNotEmpty(extraColumnNames)) {
                isExtraColumnPartition = true;
            }
        }
        List<String> tableColumnNameList = Arrays.asList(parameter.getDatabase().getTableInfoMap().get(this.getObjectName()).getCsvHeaders());
        if (parameter.getDataFormat() == DataFormat.CSV) {
            CsvFormat format = parameter.initCsvFormatMap().get(this.objectName);
            format = format.withSkipHeaderRecord(parameter.isSkipHeader() && this.isCanSkipFirstRecord());
            if (CollectionUtils.isNotEmpty(this.headers)) {
                format = format.withHeader(this.headers.toArray(new String[0]));
            }
            stream = this.openBoundedStream(fileEncoding);
            return format.parse(new InputStreamReader(stream, fileEncoding), parameter.isAutoColumnMapping(), extraColumnNames, extraColumnValues, isExtraColumnPartition, tableColumnNameList);
        }
        if (parameter.getDataFormat() == DataFormat.CUT) {
            this.skipFooter = parameter.isSkipFooter();
            String nullStr = parameter.getNullString();
            String emptyStr = parameter.getEmptyString();
            String splitter = parameter.getColumnSplitter();
            Preconditions.checkArgument((splitter.length() > 0 ? 1 : 0) != 0, (Object)"--column-splitter cannot be empty");
            boolean isTrail = parameter.isTrailingDelimiter();
            boolean isTrim = parameter.isWithTrim();
            String lineSep = parameter.getLineSeparator();
            Character escape = parameter.isIgnoreEscape() ? null : parameter.getEscapeCharacter();
            InputStream stream2 = this.openBoundedStream(fileEncoding);
            return CutRecordParserV2.parse(stream2, fileEncoding, nullStr, emptyStr, splitter, isTrail, escape, isTrim, lineSep, this.skipHeader);
        }
        if (parameter.getDataFormat() == DataFormat.POS) {
            List<Offset> offsets = parameter.getControlManager().getOffsets(this.schemaName, this.objectName);
            stream = this.openBoundedStream(fileEncoding);
            return PosRecordParser.parse(stream, fileEncoding, parameter.getLineSeparator(), offsets);
        }
        if (parameter.getDataFormat() == DataFormat.SQL) {
            InputStream stream3 = this.openBoundedStream(fileEncoding);
            return SqlRecordParser.parse(stream3, fileEncoding, parameter.getConnectionKey().getServerMode());
        }
        if (parameter.getDataFormat() == DataFormat.ORC) {
            urlFilePath = new Path(this.filePath).toUri().toString();
            return OrcRecordParserV2.parse(urlFilePath, configuration, parameter.isAutoColumnMapping(), extraColumnNames, extraColumnValues, isExtraColumnPartition, tableColumnNameList, this.stripes);
        }
        if (parameter.getDataFormat() == DataFormat.PAR) {
            urlFilePath = new Path(this.filePath).toUri().toString();
            return ParquetRecordParserV2.parse(urlFilePath, configuration, parameter.isAutoColumnMapping(), extraColumnNames, extraColumnValues, isExtraColumnPartition, tableColumnNameList);
        }
        if (parameter.getDataFormat() == DataFormat.AVRO) {
            return AvroRecordParser.parse(storageConfig.getFileSystem(), this.filePath);
        }
        throw new IllegalArgumentException("Unsupported data format: " + (Object)((Object)parameter.getDataFormat()));
    }

    public String getUniquePath() {
        int fileNameIdx;
        String path;
        String fileName = path = this.filePath;
        StringBuilder sb = new StringBuilder();
        int separatorIndex = path.lastIndexOf(File.separator);
        if (separatorIndex > 0) {
            fileName = path.substring(separatorIndex);
            sb.append(path, 0, separatorIndex);
        }
        if ((fileNameIdx = fileName.indexOf(46)) > -1) {
            sb.append(fileName, 0, fileNameIdx);
        } else {
            sb.append(fileName);
        }
        if (this.index > 0) {
            sb.append("-").append(this.index);
        }
        if (fileNameIdx < 0) {
            return sb.toString();
        }
        return sb.append(fileName.substring(fileNameIdx)).toString();
    }

    public boolean isCanSkipFirstRecord() {
        return this.index < 2;
    }

    public String getObjectName() {
        if (StringUtils.isNotBlank(this.objectName)) {
            return this.objectName;
        }
        this.objectName = FileUtils.getFileNameWithoutSuffix(this.filePath.toString());
        return this.objectName;
    }

    public void addParsedCount(int count) {
        this.parsedCount.addAndGet(count);
    }

    public void addLoadedCount(int count) {
        this.loadedCount.addAndGet(count);
    }

    public void addLoadedBytes(long bytes) {
        this.loadedBytes.addAndGet(bytes);
    }

    public void setTaskState(TaskState taskState) {
        if (taskState == null) {
            throw new IllegalArgumentException("The task state is null");
        }
        this.taskState = taskState;
    }

    public void compareAndSetState(TaskState expected, TaskState update) {
        if (this.taskState == null || this.taskState == expected) {
            this.taskState = update;
        }
    }

    public boolean isFinished() {
        return this.getTaskState().getCode() > TaskState.RUNNING.getCode();
    }

    public boolean isSuccess() {
        return this.getTaskState().getCode() == TaskState.SUCCESS.getCode();
    }

    public boolean isFailure() {
        return this.getTaskState().getCode() == TaskState.FAILURE.getCode();
    }

    public double getProgress() {
        long loadedBytes = this.getLoadedBytes().get();
        if (this.isFinished() || loadedBytes >= this.getTotalSize()) {
            return 100.0;
        }
        return new BigDecimal(100.0 * (double)loadedBytes / (double)this.getTotalSize()).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public void close() {
        if (this.resource != null) {
            try {
                this.resource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public int compareTo(SubFile o) {
        SubFile s1 = this;
        SubFile s2 = o;
        if (s1.getTotalSize() > s2.getTotalSize()) {
            return -1;
        }
        if (s1.getTotalSize() < s2.getTotalSize()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubFile subFile = (SubFile)o;
        return this.index == subFile.index && this.offset == subFile.offset && this.totalSize == subFile.totalSize && this.partitionId == subFile.partitionId && Objects.equals(this.headers, subFile.headers) && this.schemaName.equals(subFile.schemaName) && this.objectName.equals(subFile.objectName) && this.objectType.equals(subFile.objectType) && this.filePath.equals(subFile.filePath) && this.resource.equals(subFile.resource) && this.dataFormat == subFile.dataFormat;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.headers, this.index, this.offset, this.totalSize, this.schemaName, this.objectName, this.objectType, this.partitionId, this.filePath, this.resource, this.dataFormat});
    }

    public int getUid() {
        return this.uid;
    }

    public AtomicLong getParsedCount() {
        return this.parsedCount;
    }

    public AtomicLong getLoadedCount() {
        return this.loadedCount;
    }

    public AtomicLong getLoadedBytes() {
        return this.loadedBytes;
    }

    public AtomicLong getErrorCounts() {
        return this.errorCounts;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public int getIndex() {
        return this.index;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public ResourceV2 getResource() {
        return this.resource;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public TaskDetail getTaskDetail() {
        return this.taskDetail;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public int getRetryOffset() {
        return this.retryOffset;
    }

    public boolean isSkipHeader() {
        return this.skipHeader;
    }

    public boolean isSkipFooter() {
        return this.skipFooter;
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public List<String> getParentDirNames() {
        return this.parentDirNames;
    }

    public List<StripeInformation> getStripes() {
        return this.stripes;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public void setHeaders(List<String> headers) {
        this.headers = headers;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public void setPartitionId(long partitionId) {
        this.partitionId = partitionId;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setResource(ResourceV2 resource) {
        this.resource = resource;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setTaskDetail(TaskDetail taskDetail) {
        this.taskDetail = taskDetail;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public void setRetryOffset(int retryOffset) {
        this.retryOffset = retryOffset;
    }

    public void setSkipHeader(boolean skipHeader) {
        this.skipHeader = skipHeader;
    }

    public void setSkipFooter(boolean skipFooter) {
        this.skipFooter = skipFooter;
    }

    public void setParentDirNames(List<String> parentDirNames) {
        this.parentDirNames = parentDirNames;
    }

    public void setStripes(List<StripeInformation> stripes) {
        this.stripes = stripes;
    }
}

