/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.constants.JdbcType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.Pair;
import com.oceanbase.tools.loaddump.common.model.RangeKey;
import com.oceanbase.tools.loaddump.utils.ArrayUtils;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;

public class TableRangeInfo {
    private String tableName;
    private List<Pair<RangeKey[], RangeKey[]>> rangeList;
    private String partitionName;
    private List<Pair<String, String>> wrappedPkCols2DataType;

    public TableRangeInfo(String tableName) {
        this(tableName, null);
    }

    public TableRangeInfo(String tableName, String partitionName) {
        this(tableName, null, null, partitionName);
    }

    public TableRangeInfo(String tableName, List<Pair<RangeKey[], RangeKey[]>> rangeList, List<Pair<String, String>> wrappedPkCols2DataType, String partitionName) {
        this.tableName = tableName;
        this.rangeList = rangeList;
        this.partitionName = partitionName;
        this.wrappedPkCols2DataType = wrappedPkCols2DataType;
    }

    public boolean isPartitioned() {
        return StringUtils.isNotEmpty(this.partitionName);
    }

    public boolean hasPrimary() {
        return CollectionUtils.isNotEmpty(this.rangeList);
    }

    public List<StringBuilder> getPrimaryPlaceHolders(@NonNull ServerMode serverMode) {
        if (serverMode == null) {
            throw new NullPointerException("serverMode is marked non-null but is null");
        }
        ArrayList list = Lists.newArrayList();
        if (!this.hasPrimary()) {
            return list;
        }
        String wrappedPks = this.wrappedPkCols2DataType.stream().map(e -> ServerMode.MYSQL.equals((Object)serverMode) && e.getRight() != null && JdbcType.isBinaryType((String)e.getRight()) ? "hex(" + (String)e.getLeft() + ")" : (String)e.getLeft()).collect(Collectors.joining(","));
        for (Pair<RangeKey[], RangeKey[]> range : this.rangeList) {
            RangeKey[] startValues = range.getLeft();
            RangeKey[] endValues = range.getRight();
            StringBuilder sb = new StringBuilder(128);
            boolean hasStartValues = ArrayUtils.isNotEmpty(startValues);
            boolean hasEndValues = ArrayUtils.isNotEmpty(endValues);
            if (hasStartValues) {
                sb.append("(").append(wrappedPks).append(")>(");
                sb.append(Stream.of(startValues).map(RangeKey::getPlaceHolder).collect(Collectors.joining(","))).append(")");
            }
            if (hasStartValues && hasEndValues) {
                sb.append(" AND ");
            }
            if (hasEndValues) {
                sb.append("(").append(wrappedPks).append(")<=(");
                sb.append(Stream.of(endValues).map(RangeKey::getPlaceHolder).collect(Collectors.joining(","))).append(")");
            }
            list.add(sb);
        }
        return list;
    }

    public RangeKey[] getPrimaryValues(int index) {
        if (this.hasPrimary()) {
            Object[] startValues = this.rangeList.get(index).getLeft();
            Object[] endValues = this.rangeList.get(index).getRight();
            int startLen = ArrayUtils.isEmpty(startValues) ? 0 : startValues.length;
            int endLen = ArrayUtils.isEmpty(endValues) ? 0 : endValues.length;
            RangeKey[] objects = new RangeKey[startLen + endLen];
            System.arraycopy(startValues, 0, objects, 0, startLen);
            System.arraycopy(endValues, 0, objects, startLen, endLen);
            return objects;
        }
        return new RangeKey[0];
    }

    public TableRangeInfo() {
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<Pair<RangeKey[], RangeKey[]>> getRangeList() {
        return this.rangeList;
    }

    public void setRangeList(List<Pair<RangeKey[], RangeKey[]>> rangeList) {
        this.rangeList = rangeList;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }
}

