/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.model.ObjectStatus;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class TaskDetail
implements Serializable {
    private static final long serialVersionUID = 1356555646379671391L;
    private final List<ObjectStatus> objectStatusList = new ArrayList<ObjectStatus>();
    private String schema;
    private String type;
    private String object;
    private String file;
    private volatile long total;
    private volatile long count;
    private TaskType taskType;
    private transient String error;
    private AtomicLong errorCounts;
    private transient String mergeError;
    private transient TaskState state = TaskState.INITIAL;

    public String getSchemaTable() {
        return this.getSchema() + "." + this.getObject();
    }

    public boolean isFailure() {
        return this.getState().getCode() == TaskState.FAILURE.getCode();
    }

    public boolean isSuccess() {
        return this.getState().getCode() == TaskState.SUCCESS.getCode();
    }

    public boolean isFinished() {
        return this.getState().getCode() > TaskState.RUNNING.getCode();
    }

    public String toString() {
        return "TaskDetail{total=" + this.total + ", count=" + this.count + ", state=" + (Object)((Object)this.state) + ", error='" + this.error + '\'' + ", errorCounts=" + this.errorCounts + ", taskType=" + (Object)((Object)this.taskType) + '}';
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setErrorCounts(AtomicLong errorCounts) {
        this.errorCounts = errorCounts;
    }

    public void setMergeError(String mergeError) {
        this.mergeError = mergeError;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    public List<ObjectStatus> getObjectStatusList() {
        return this.objectStatusList;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getType() {
        return this.type;
    }

    public String getObject() {
        return this.object;
    }

    public String getFile() {
        return this.file;
    }

    public long getTotal() {
        return this.total;
    }

    public long getCount() {
        return this.count;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getError() {
        return this.error;
    }

    public AtomicLong getErrorCounts() {
        return this.errorCounts;
    }

    public String getMergeError() {
        return this.mergeError;
    }

    public TaskState getState() {
        return this.state;
    }
}

