/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model.datatype;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class DataType {
    private final List<String> args;
    private final String dataTypeName;

    public DataType(@NonNull String dataTypeName, @NonNull List<String> args) {
        if (dataTypeName == null) {
            throw new NullPointerException("dataTypeName is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        this.args = args;
        this.dataTypeName = dataTypeName.toLowerCase();
    }

    public DataType(@NonNull ResultSetMetaData metaData, int columnIndex) throws SQLException {
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        Validate.isTrue((columnIndex >= 0 ? 1 : 0) != 0, (String)"ColumnIndex can not be negative", (Object[])new Object[0]);
        this.dataTypeName = metaData.getColumnTypeName(columnIndex + 1).toLowerCase();
        this.args = Arrays.asList(metaData.getPrecision(columnIndex + 1) + "", metaData.getScale(columnIndex + 1) + "");
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public String toString() {
        return "DataType(args=" + this.getArgs() + ", dataTypeName=" + this.getDataTypeName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataType)) {
            return false;
        }
        DataType other = (DataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$args = this.getArgs();
        List<String> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        String this$dataTypeName = this.getDataTypeName();
        String other$dataTypeName = other.getDataTypeName();
        return !(this$dataTypeName == null ? other$dataTypeName != null : !this$dataTypeName.equals(other$dataTypeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        String $dataTypeName = this.getDataTypeName();
        result = result * 59 + ($dataTypeName == null ? 43 : $dataTypeName.hashCode());
        return result;
    }
}

