/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model.datatype.factory;

import com.oceanbase.tools.loaddump.common.model.datatype.DataType;
import com.oceanbase.tools.loaddump.common.model.datatype.ObTimeDataType;
import com.oceanbase.tools.loaddump.common.model.datatype.factory.DataTypeFactory;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractDataTypeFactory
implements DataTypeFactory {
    private int precision = -1;

    AbstractDataTypeFactory() {
    }

    protected abstract DataType doGenerate() throws Exception;

    @Override
    public DataType generate() throws Exception {
        DataType rawType = this.doGenerate();
        if (this.precision < 0) {
            return rawType;
        }
        String dataType = rawType.getDataTypeName();
        boolean timestampType = dataType.startsWith("timestamp");
        ObTimeDataType dataTypeObj = null;
        if ("date".equalsIgnoreCase(dataType)) {
            dataTypeObj = new ObTimeDataType("date", rawType.getArgs(), this.precision);
        } else if ("time".equalsIgnoreCase(dataType)) {
            dataTypeObj = new ObTimeDataType("time", rawType.getArgs(), this.precision);
        } else if ("datetime".equalsIgnoreCase(dataType)) {
            dataTypeObj = new ObTimeDataType("datetime", rawType.getArgs(), this.precision);
        } else if (dataType.startsWith("interval") || timestampType) {
            StringBuilder sb = new StringBuilder(dataType.length());
            String[] parts = dataType.split(" ");
            for (int i = 0; i < parts.length; ++i) {
                int index = parts[i].indexOf(40);
                if (index > -1) {
                    sb.append(parts[i], 0, index);
                } else {
                    sb.append(parts[i]);
                }
                if (i >= parts.length - 1) continue;
                sb.append(" ");
            }
            dataType = sb.toString();
            if (timestampType) {
                dataTypeObj = !StringUtils.containsIgnoreCase((CharSequence)dataType, (CharSequence)"with") ? new ObTimeDataType("timestamp", rawType.getArgs(), this.precision) : (!StringUtils.containsIgnoreCase((CharSequence)dataType, (CharSequence)"local") ? new ObTimeDataType("timestamp with time zone", rawType.getArgs(), this.precision) : new ObTimeDataType("timestamp with local time zone", rawType.getArgs(), this.precision));
            }
        }
        return dataTypeObj == null ? rawType : dataTypeObj;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }
}

