/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model.datatype.factory;

import com.oceanbase.tools.loaddump.common.model.datatype.DataType;
import com.oceanbase.tools.loaddump.common.model.datatype.factory.AbstractDataTypeFactory;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class JdbcDataTypeFactory
extends AbstractDataTypeFactory {
    private final ResultSetMetaData metaData;
    private final int columnIndex;

    public JdbcDataTypeFactory(@NonNull ResultSetMetaData metaData, int columnIndex) {
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        this.metaData = metaData;
        this.columnIndex = columnIndex;
    }

    @Override
    public DataType generate() throws Exception {
        return this.doGenerate();
    }

    @Override
    protected DataType doGenerate() throws SQLException {
        String dataType = this.metaData.getColumnTypeName(this.columnIndex + 1);
        if (StringUtils.isEmpty((CharSequence)dataType)) {
            return new DataType("VARCHAR", Collections.emptyList());
        }
        return new DataType(this.metaData, this.columnIndex);
    }
}

