/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model.datatype.factory;

import com.oceanbase.tools.loaddump.common.model.datatype.DataType;
import com.oceanbase.tools.loaddump.common.model.datatype.factory.AbstractDataTypeFactory;
import com.oceanbase.tools.loaddump.common.model.datatype.parser.DataTypeParser;
import com.oceanbase.tools.loaddump.common.model.datatype.parser.DataTypeToken;
import com.oceanbase.tools.loaddump.common.model.datatype.parser.DataTypeTokenVisitor;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralDataTypeFactory
extends AbstractDataTypeFactory
implements DataTypeTokenVisitor {
    private static final Logger log = LoggerFactory.getLogger(LiteralDataTypeFactory.class);
    private Integer bracketCounter = 0;
    private final List<String> dataTypeNames = new ArrayList<String>();
    private final List<String> args = new ArrayList<String>();

    public LiteralDataTypeFactory(@NonNull String dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        DataTypeParser parser = new DataTypeParser(DataTypeParser.getTokens(dataType));
        parser.parse(this);
    }

    @Override
    protected DataType doGenerate() {
        return new DataType(String.join((CharSequence)" ", this.dataTypeNames), this.args);
    }

    @Override
    public void visitName(@NonNull DataTypeToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (this.bracketCounter <= 0) {
            this.dataTypeNames.add(token.getText());
        } else {
            this.args.add(token.getText());
        }
    }

    @Override
    public void visitNumber(@NonNull DataTypeToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        try {
            this.args.add(token.getText());
        }
        catch (Exception e) {
            log.warn("Failed to parse integer, token={}", (Object)token, (Object)e);
        }
    }

    @Override
    public void visitUnknown(@NonNull DataTypeToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
    }

    @Override
    public void visitBrackets(@NonNull DataTypeToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if ("(".equals(token.getText())) {
            Integer n = this.bracketCounter;
            Integer n2 = this.bracketCounter = Integer.valueOf(this.bracketCounter + 1);
        } else if (")".equals(token.getText())) {
            Integer n = this.bracketCounter;
            Integer n3 = this.bracketCounter = Integer.valueOf(this.bracketCounter - 1);
        }
    }
}

