/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.thread;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorTemplate<T> {
    public static int DEFAULT_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private final boolean autoClose;
    private final List<Future<T>> futures;
    private final ExecutorService internalExecutor;
    private final ExecutorCompletionService<T> completionService;

    public static void setPoolSize(int size) {
        DEFAULT_POOL_SIZE = size;
    }

    public ExecutorTemplate(String poolName) {
        this(ExecutorTemplate.defaultExecutor(poolName), true);
    }

    public ExecutorTemplate(String poolName, int poolSize) {
        this(ExecutorTemplate.defaultExecutor(poolName, poolSize), true);
    }

    public ExecutorTemplate(ExecutorService executor) {
        this(executor, true);
    }

    private ExecutorTemplate(ExecutorService executor, boolean autoClose) {
        this.autoClose = autoClose;
        this.internalExecutor = executor;
        this.completionService = new ExecutorCompletionService(executor);
        this.futures = Collections.synchronizedList(new ArrayList());
    }

    private static ExecutorService defaultExecutor(String poolName) {
        return ExecutorTemplate.defaultExecutor(128, poolName, DEFAULT_POOL_SIZE);
    }

    private static ExecutorService defaultExecutor(String poolName, int poolSize) {
        return ExecutorTemplate.defaultExecutor(128, poolName, poolSize);
    }

    private static ExecutorService defaultExecutor(int capacity, String poolName, int poolSize) {
        return new ThreadPoolExecutor(poolSize, poolSize, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(capacity), new NamedThreadFactory(poolName), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void submit(Callable<T> task) {
        Future<T> f = this.completionService.submit(task);
        this.futures.add(f);
        this.check(f);
    }

    public void submit(Runnable task) {
        Future<Object> f = this.completionService.submit(task, null);
        this.futures.add(f);
        this.check(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> waitForResult() {
        try {
            Throwable ex = null;
            ArrayList<T> result = new ArrayList<T>();
            for (int index = 0; index < this.futures.size(); ++index) {
                try {
                    Future<T> f = this.completionService.take();
                    result.add(f.get());
                    continue;
                }
                catch (Throwable e) {
                    ex = this.getRootCause(e);
                    break;
                }
            }
            if (ex != null) {
                this.cancelAll();
                throw new RuntimeException(ex);
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
        finally {
            this.clearFutures();
            if (this.autoClose) {
                this.destroyExecutor();
            }
        }
    }

    public void cancelAll() {
        for (Future<T> f : this.futures) {
            if (f.isDone() || f.isCancelled()) continue;
            f.cancel(false);
        }
    }

    public void clearFutures() {
        this.futures.clear();
    }

    public void destroyExecutor() {
        if (this.internalExecutor != null && !this.internalExecutor.isShutdown()) {
            this.internalExecutor.shutdown();
            try {
                this.internalExecutor.awaitTermination(0L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void check(Future<T> f) {
        if (f != null && f.isDone()) {
            try {
                f.get();
            }
            catch (Throwable e) {
                this.cancelAll();
                throw new RuntimeException(e);
            }
        }
    }

    private Throwable getRootCause(Throwable throwable) {
        Throwable holder = throwable;
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return list.size() < 2 ? holder : (Throwable)list.get(list.size() - 1);
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        private final boolean daemon;
        private final String name;
        private final AtomicInteger seq = new AtomicInteger(0);

        public NamedThreadFactory(String name) {
            this(name, false);
        }

        public NamedThreadFactory(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(this.daemon);
            t.setPriority(5);
            t.setName(this.name + this.seq.incrementAndGet());
            return t;
        }
    }
}

