/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.thread;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.thread.NamedThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadPoolBuilder {
    private int corePoolSize;
    private int maximumPoolSize;
    private long keepAliveTime;
    private TimeUnit unit;
    private BlockingQueue<Runnable> workQueue;
    private ThreadFactory threadFactory;

    public ThreadPoolBuilder() {
        this.maximumPoolSize = this.corePoolSize = Constants.DEFAULT_IO_THREADS;
        this.keepAliveTime = 0L;
        this.unit = TimeUnit.SECONDS;
        this.workQueue = new ArrayBlockingQueue<Runnable>(1024);
        this.threadFactory = new NamedThreadFactory("default-pool-");
    }

    public ThreadPoolBuilder setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
        return this;
    }

    public ThreadPoolBuilder setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
        return this;
    }

    public ThreadPoolBuilder setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        return this;
    }

    public ThreadPoolBuilder setTimeUnit(TimeUnit unit) {
        this.unit = unit;
        return this;
    }

    public ThreadPoolBuilder setQueueSize(int capacity) {
        this.workQueue = new ArrayBlockingQueue<Runnable>(capacity);
        return this;
    }

    public ThreadPoolBuilder setThreadPrefixName(String threadPrefixName) {
        this.threadFactory = new NamedThreadFactory(threadPrefixName);
        return this;
    }

    public ThreadPoolExecutor build() {
        return new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.unit, this.workQueue, this.threadFactory);
    }
}

