/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.unit;

import com.oceanbase.tools.loaddump.common.unit.BinarySizeUnit;
import org.apache.commons.lang3.Validate;

public class BinarySize
implements Comparable<BinarySize> {
    private static final BinarySizeUnit[] ORDERED_SIZE_UNIT_DESC = new BinarySizeUnit[]{BinarySizeUnit.EB, BinarySizeUnit.PB, BinarySizeUnit.TB, BinarySizeUnit.GB, BinarySizeUnit.MB, BinarySizeUnit.KB, BinarySizeUnit.B};
    private final long sizeDigit;
    private final BinarySizeUnit sizeUnit;
    private BinarySize mod;

    BinarySize(long sizeDigit, BinarySizeUnit sizeUnit) {
        Validate.isTrue((sizeDigit >= 0L ? 1 : 0) != 0, (String)"Size is overflow", (Object[])new Object[0]);
        long limit = sizeUnit.upperLimit;
        Validate.isTrue((sizeDigit <= limit ? 1 : 0) != 0, (String)("Upper limit for " + (Object)((Object)sizeUnit) + " is " + limit + ", actual is " + sizeDigit), (Object[])new Object[0]);
        this.sizeDigit = sizeDigit;
        this.sizeUnit = sizeUnit;
    }

    @Override
    public int compareTo(BinarySize that) {
        BinarySize thisSize = this.convert(BinarySizeUnit.B);
        BinarySize thatSize = that.convert(BinarySizeUnit.B);
        return Long.compare(thisSize.sizeDigit, thatSize.sizeDigit);
    }

    public int hashCode() {
        return Long.hashCode(this.convert(BinarySizeUnit.B).getSizeDigit());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BinarySize)) {
            return false;
        }
        BinarySize that = (BinarySize)obj;
        return this.compareTo(that) == 0;
    }

    public BinarySize convert(BinarySizeUnit thatSizeUnit) {
        long sizeBytes = this.sizeDigit << this.sizeUnit.byteOffset;
        BinarySize tmpMod = this.mod;
        while (tmpMod != null) {
            sizeBytes |= tmpMod.sizeDigit << tmpMod.sizeUnit.byteOffset;
            tmpMod = tmpMod.mod;
        }
        int index = BinarySize.indexOf(thatSizeUnit);
        BinarySize returnVal = null;
        BinarySize prev = null;
        for (int i = index; i < ORDERED_SIZE_UNIT_DESC.length && sizeBytes > 0L; ++i) {
            BinarySize current;
            BinarySizeUnit tmpUnit = ORDERED_SIZE_UNIT_DESC[i];
            if (sizeBytes <= tmpUnit.byteBoundary) {
                current = new BinarySize(0L, tmpUnit);
            } else {
                current = new BinarySize(sizeBytes >> tmpUnit.byteOffset, tmpUnit);
                sizeBytes &= tmpUnit.byteBoundary;
            }
            if (returnVal == null) {
                returnVal = current;
            }
            if (prev != null) {
                prev.mod = current;
            }
            prev = current;
        }
        return returnVal == null ? new BinarySize(0L, thatSizeUnit) : returnVal;
    }

    public String toString() {
        BinarySizeUnit targetUnit = null;
        for (BinarySizeUnit unit : ORDERED_SIZE_UNIT_DESC) {
            if (this.compareTo(unit.of(1L)) < 0) continue;
            targetUnit = unit;
            break;
        }
        if (targetUnit == null) {
            return "0 B";
        }
        StringBuilder buffer = new StringBuilder();
        BinarySize tmp = this.convert(targetUnit);
        if (tmp.mod != null) {
            buffer.append(String.format("%.1f", (double)(tmp.sizeDigit * 1024L + tmp.mod.sizeDigit) / 1024.0));
        } else {
            buffer.append(tmp.sizeDigit);
        }
        return buffer.append(" ").append(tmp.sizeUnit.name()).toString();
    }

    private static int indexOf(BinarySizeUnit unit) {
        switch (unit) {
            case EB: {
                return 0;
            }
            case PB: {
                return 1;
            }
            case TB: {
                return 2;
            }
            case GB: {
                return 3;
            }
            case MB: {
                return 4;
            }
            case KB: {
                return 5;
            }
            case B: {
                return 6;
            }
        }
        throw new IllegalArgumentException("Unknown size unit, " + (Object)((Object)unit));
    }

    public long getSizeDigit() {
        return this.sizeDigit;
    }

    public BinarySizeUnit getSizeUnit() {
        return this.sizeUnit;
    }

    public BinarySize getMod() {
        return this.mod;
    }
}

