/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.unit;

import com.oceanbase.tools.loaddump.common.unit.BinarySize;

public enum BinarySizeUnit {
    EB(60, 7L),
    PB(50, 8191L),
    TB(40, 0x7FFFFFL),
    GB(30, 0x1FFFFFFFFL),
    MB(20, 0x7FFFFFFFFFFL),
    KB(10, 0x1FFFFFFFFFFFFFL),
    B(0, Long.MAX_VALUE);

    static final long SIZE_BOUNDARY = 0xFFFFFFFFFFFFFFFL;
    final int byteOffset;
    final long upperLimit;
    final long byteBoundary;

    private BinarySizeUnit(int byteOffset, long upperLimit) {
        this.byteOffset = byteOffset;
        this.upperLimit = upperLimit;
        this.byteBoundary = byteOffset == 0 ? 0L : 0xFFFFFFFFFFFFFFFL >> 60 - byteOffset;
    }

    public BinarySize of(long sizeDigit) {
        return new BinarySize(sizeDigit, this);
    }
}

