/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.compress;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public enum CompressAlgo {
    NONE("none", "", Integer.MIN_VALUE, Integer.MAX_VALUE),
    ZSTD("zstd", ".zst", 1, 22),
    ZLIB("zlib", ".zz", -1, 9),
    GZIP("gzip", ".gz", -1, 9),
    SNAPPY("snappy", ".sz", Integer.MIN_VALUE, Integer.MAX_VALUE);

    private static final Map<String, CompressAlgo> ALGO_MAP;
    private final String algoName;
    private final String suffix;
    private final int minLevel;
    private final int maxLevel;

    public static CompressAlgo of(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        CompressAlgo algo = ALGO_MAP.get(name.toLowerCase());
        if (algo != null) {
            return algo;
        }
        throw new IllegalArgumentException("Unknown compression algorithm: " + name);
    }

    private CompressAlgo(String algoName, String suffix, int minLevel, int maxLevel) {
        this.algoName = algoName;
        this.suffix = suffix;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    public void checkLevelValid(int compressLevel) {
        Preconditions.checkArgument((compressLevel <= this.maxLevel && compressLevel >= this.minLevel ? 1 : 0) != 0, (String)"Invalid compression level, valid range: [%s,%s]", (int)this.minLevel, (int)this.maxLevel);
    }

    public String getAlgoName() {
        return this.algoName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    static {
        ALGO_MAP = new HashMap<String, CompressAlgo>();
        for (CompressAlgo algo : CompressAlgo.values()) {
            ALGO_MAP.put(algo.algoName.toLowerCase(), algo);
        }
    }
}

