/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.compress;

import com.oceanbase.tools.loaddump.compress.CompressAlgo;
import com.oceanbase.tools.loaddump.compress.Compressor;
import com.oceanbase.tools.loaddump.compress.GzipCompressor;
import com.oceanbase.tools.loaddump.compress.NoOpCompressor;
import com.oceanbase.tools.loaddump.compress.SnappyCompressor;
import com.oceanbase.tools.loaddump.compress.ZlibCompressor;
import com.oceanbase.tools.loaddump.compress.ZstdCompressor;
import lombok.NonNull;

public class CompressorFactory {
    public static Compressor getCompressor(@NonNull CompressAlgo algo, int level) {
        if (algo == null) {
            throw new NullPointerException("algo is marked non-null but is null");
        }
        switch (algo) {
            case NONE: {
                return new NoOpCompressor();
            }
            case ZSTD: {
                return new ZstdCompressor(level);
            }
            case GZIP: {
                return new GzipCompressor();
            }
            case ZLIB: {
                return new ZlibCompressor(level);
            }
            case SNAPPY: {
                return new SnappyCompressor();
            }
        }
        throw new IllegalArgumentException("Unsupported compress type:" + (Object)((Object)algo));
    }

    public static Compressor getCompressor(@NonNull String algo, int level) {
        if (algo == null) {
            throw new NullPointerException("algo is marked non-null but is null");
        }
        return CompressorFactory.getCompressor(CompressAlgo.of(algo), level);
    }
}

