/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.configure;

import com.oceanbase.tools.loaddump.common.SessionManager;
import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.configure.Global;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Configure {
    private final DbType dbType;
    private final String schemaName;
    private final Map<ObjectType, Set<String>> blackListMap = new HashMap<ObjectType, Set<String>>();
    private final Map<ObjectType, Set<String>> whiteListMap = new HashMap<ObjectType, Set<String>>();
    private final SessionManager sessionManager;
    private final Set<String> includeObjectTypes;
    private Global global;
    private boolean ignoreCycleReference;
    private boolean ignoreCheckReference;
    private String sequencePolicy;

    public Configure(@NonNull Global global, @NonNull DbType dbType, @NonNull String schemaName, @NonNull String sequencePolicy) {
        this(global, dbType, schemaName, null, null, sequencePolicy);
        if (global == null) {
            throw new NullPointerException("global is marked non-null but is null");
        }
        if (dbType == null) {
            throw new NullPointerException("dbType is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        if (sequencePolicy == null) {
            throw new NullPointerException("sequencePolicy is marked non-null but is null");
        }
    }

    public Configure(@NonNull Global global, @NonNull DbType dbType, @NonNull String schemaName, SessionManager sm, Set<String> includeObjectTypes, String sequencePolicy) {
        if (global == null) {
            throw new NullPointerException("global is marked non-null but is null");
        }
        if (dbType == null) {
            throw new NullPointerException("dbType is marked non-null but is null");
        }
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        this.global = global;
        this.dbType = dbType;
        this.sessionManager = sm;
        this.schemaName = schemaName;
        this.includeObjectTypes = includeObjectTypes == null ? new HashSet() : includeObjectTypes;
        this.sequencePolicy = sequencePolicy;
    }

    public String getFilterString(ObjectType objectType) {
        Set<String> whitelist = this.whiteListMap.get((Object)objectType);
        Set<String> blacklist = this.blackListMap.get((Object)objectType);
        if (CollectionUtils.isEmpty(whitelist)) {
            if (CollectionUtils.isEmpty(blacklist)) {
                return "IS NOT NULL";
            }
            return "NOT IN (" + this.joinValueString(blacklist) + ")";
        }
        if (CollectionUtils.isNotEmpty(blacklist)) {
            whitelist.removeAll(blacklist);
            if (CollectionUtils.isEmpty(whitelist)) {
                return "IS NOT NULL";
            }
        }
        return "IN (" + this.joinValueString(whitelist) + ")";
    }

    private String joinValueString(Collection<String> collection) {
        return collection.stream().map(e -> "'" + e.replace("'", "''") + "'").collect(Collectors.joining(","));
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Map<ObjectType, Set<String>> getBlackListMap() {
        return this.blackListMap;
    }

    public Map<ObjectType, Set<String>> getWhiteListMap() {
        return this.whiteListMap;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public Set<String> getIncludeObjectTypes() {
        return this.includeObjectTypes;
    }

    public Global getGlobal() {
        return this.global;
    }

    public boolean isIgnoreCycleReference() {
        return this.ignoreCycleReference;
    }

    public boolean isIgnoreCheckReference() {
        return this.ignoreCheckReference;
    }

    public String getSequencePolicy() {
        return this.sequencePolicy;
    }

    public void setGlobal(Global global) {
        this.global = global;
    }

    public void setIgnoreCycleReference(boolean ignoreCycleReference) {
        this.ignoreCycleReference = ignoreCycleReference;
    }

    public void setIgnoreCheckReference(boolean ignoreCheckReference) {
        this.ignoreCheckReference = ignoreCheckReference;
    }

    public void setSequencePolicy(String sequencePolicy) {
        this.sequencePolicy = sequencePolicy;
    }
}

