/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control;

import com.oceanbase.tools.loaddump.control.function.Invokers;
import com.oceanbase.tools.loaddump.control.function.SqlFunction;
import com.oceanbase.tools.loaddump.control.generation.AbstractGeneratedDefine;
import com.oceanbase.tools.loaddump.parser.record.pos.Offset;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class ControlDescription {
    private final int columnId;
    private String columnName;
    private final List<SqlFunction> callStacks = new ArrayList<SqlFunction>();
    private int refColumnId;
    private String refColumnName;
    private Offset offset;
    private Integer mappedIndex;
    private AbstractGeneratedDefine generatedDefine;

    public ControlDescription(String columnName) {
        this(0, columnName);
    }

    public ControlDescription(int columnId, String columnName) {
        this(columnId, columnName, columnId, columnName);
    }

    public ControlDescription(int columnId, String columnName, int refColumnId, String refColumnName) {
        this.columnId = columnId;
        this.columnName = columnName;
        this.refColumnId = refColumnId;
        this.refColumnName = refColumnName;
    }

    public void add(SqlFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("function is null");
        }
        this.getCallStacks().add(function);
    }

    public String invoke() {
        return this.invoke(null);
    }

    public String invoke(String value) {
        return Invokers.invoke0(this.getCallStacks(), value);
    }

    private String getCallTrace() {
        List<SqlFunction> funcs = this.getCallStacks();
        if (CollectionUtils.isEmpty(funcs)) {
            return "NONE";
        }
        StringBuilder sb = new StringBuilder(64);
        for (int i = funcs.size() - 1; i > -1; --i) {
            sb.append(funcs.get(i).getName());
            if (i <= 0) continue;
            sb.append(" -> ");
        }
        return sb.toString();
    }

    public String toString() {
        return "ColumnDescription [columnId=" + this.columnId + ", columnName=" + this.columnName + ", refColumnId=" + this.refColumnId + ", refColumnName=" + this.refColumnName + ", offset=" + this.offset + ", callStacks=" + this.getCallTrace() + "]";
    }

    public int getColumnId() {
        return this.columnId;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public List<SqlFunction> getCallStacks() {
        return this.callStacks;
    }

    public int getRefColumnId() {
        return this.refColumnId;
    }

    public String getRefColumnName() {
        return this.refColumnName;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public Integer getMappedIndex() {
        return this.mappedIndex;
    }

    public AbstractGeneratedDefine getGeneratedDefine() {
        return this.generatedDefine;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setRefColumnId(int refColumnId) {
        this.refColumnId = refColumnId;
    }

    public void setRefColumnName(String refColumnName) {
        this.refColumnName = refColumnName;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public void setMappedIndex(Integer mappedIndex) {
        this.mappedIndex = mappedIndex;
    }

    public void setGeneratedDefine(AbstractGeneratedDefine generatedDefine) {
        this.generatedDefine = generatedDefine;
    }
}

