/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.expression;

import com.oceanbase.tools.loaddump.control.expression.AbstractExpression;
import com.oceanbase.tools.loaddump.control.expression.Expression;
import com.oceanbase.tools.loaddump.control.function.Invokers;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalExpression
extends AbstractExpression {
    private static final Logger log = LoggerFactory.getLogger(LogicalExpression.class);
    private String logicalOperator;
    private List<Expression> leftExprs = new ArrayList<Expression>();
    private List<Expression> rightExprs = new ArrayList<Expression>();

    @Override
    public boolean eval(String value) {
        value = Invokers.invoke0(this.getFuncs(), value);
        boolean lexpr = this.eval(this.getLeftExprs(), value);
        boolean rexpr = this.eval(this.getRightExprs(), value);
        String operator = this.getLogicalOperator().trim();
        if ("AND".equalsIgnoreCase(operator) || "&&".equals(operator)) {
            return lexpr && rexpr;
        }
        if ("OR".equalsIgnoreCase(operator) || "||".equals(operator)) {
            return lexpr || rexpr;
        }
        log.warn("Unsupported logical operator: {} {} {}", new Object[]{lexpr, operator, rexpr});
        return false;
    }

    public String getLogicalOperator() {
        return this.logicalOperator;
    }

    public void setLogicalOperator(String logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public List<Expression> getLeftExprs() {
        return this.leftExprs;
    }

    public void setLeftExprs(List<Expression> leftExprs) {
        this.leftExprs = leftExprs;
    }

    public List<Expression> getRightExprs() {
        return this.rightExprs;
    }

    public void setRightExprs(List<Expression> rightExprs) {
        this.rightExprs = rightExprs;
    }
}

