/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.advance;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.expression.Expression;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.control.function.Invokers;
import com.oceanbase.tools.loaddump.control.function.SqlFunction;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class SearchCaseFunction
extends AbstractBuiltinFunction {
    private final List<SearchCaseFuncAlternative> caseFuncAlternatives = new ArrayList<SearchCaseFuncAlternative>();
    private SearchElseFuncAlternative elseFuncAlternative;

    @Override
    public String getName() {
        return SqlFunctions.SEARCH_CASE.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return this.doSearchCaseWhen(varargs == null ? null : varargs[0]);
    }

    private String doSearchCaseWhen(String value) {
        SearchElseFuncAlternative elseFunc;
        String origin = value;
        List<SearchCaseFuncAlternative> alternatives = this.getCaseFuncAlternatives();
        if (CollectionUtils.isNotEmpty(alternatives)) {
            for (SearchCaseFuncAlternative alter : alternatives) {
                if (!alter.getConditionArg().eval(value)) continue;
                return Invokers.invoke0(alter.getConsequentArg(), origin);
            }
        }
        return (elseFunc = this.getElseFuncAlternative()) == null ? null : Invokers.invoke0(elseFunc.getElseArg(), origin);
    }

    public List<SearchCaseFuncAlternative> getCaseFuncAlternatives() {
        return this.caseFuncAlternatives;
    }

    public SearchElseFuncAlternative getElseFuncAlternative() {
        return this.elseFuncAlternative;
    }

    public void setElseFuncAlternative(SearchElseFuncAlternative elseFuncAlternative) {
        this.elseFuncAlternative = elseFuncAlternative;
    }

    public static class SearchElseFuncAlternative {
        private List<SqlFunction> elseArg = new ArrayList<SqlFunction>();

        public String toString() {
            return "SearchElseFuncAlternative [elseArg=" + this.elseArg + "]";
        }

        public List<SqlFunction> getElseArg() {
            return this.elseArg;
        }
    }

    public static class SearchCaseFuncAlternative {
        private final List<SqlFunction> consequentArg = new ArrayList<SqlFunction>();
        private Expression conditionArg;

        public String toString() {
            return "SearchCaseFuncAlternative [conditionArg=" + this.conditionArg + ", consequentArg=" + this.consequentArg + "]";
        }

        public List<SqlFunction> getConsequentArg() {
            return this.consequentArg;
        }

        public Expression getConditionArg() {
            return this.conditionArg;
        }

        public void setConditionArg(Expression conditionArg) {
            this.conditionArg = conditionArg;
        }
    }
}

