/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.advance;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.control.function.Invokers;
import com.oceanbase.tools.loaddump.control.function.SqlFunction;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class SimpleCaseFunction
extends AbstractBuiltinFunction {
    private final List<SqlFunction> callStacks = new ArrayList<SqlFunction>();
    private final List<SimpleCaseFuncAlternative> caseFuncAlternatives = new ArrayList<SimpleCaseFuncAlternative>();
    private SimpleElseFuncAlternative elseFuncAlternative;

    @Override
    public String getName() {
        return SqlFunctions.SIMPLE_CASE.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return this.doSimpleCaseWhen(varargs == null ? null : varargs[0]);
    }

    private String doSimpleCaseWhen(String value) {
        SimpleElseFuncAlternative elseFunc;
        String origin = value;
        value = Invokers.invoke0(this.callStacks, value);
        List<SimpleCaseFuncAlternative> alternatives = this.getCaseFuncAlternatives();
        if (CollectionUtils.isNotEmpty(alternatives)) {
            for (SimpleCaseFuncAlternative alter : alternatives) {
                if (!alter.getConditionArg().equals(value)) continue;
                return Invokers.invoke0(alter.getConsequentArg(), origin);
            }
        }
        return (elseFunc = this.getElseFuncAlternative()) == null ? null : Invokers.invoke0(elseFunc.getElseArg(), origin);
    }

    public List<SqlFunction> getCallStacks() {
        return this.callStacks;
    }

    public List<SimpleCaseFuncAlternative> getCaseFuncAlternatives() {
        return this.caseFuncAlternatives;
    }

    public SimpleElseFuncAlternative getElseFuncAlternative() {
        return this.elseFuncAlternative;
    }

    public void setElseFuncAlternative(SimpleElseFuncAlternative elseFuncAlternative) {
        this.elseFuncAlternative = elseFuncAlternative;
    }

    public static class SimpleElseFuncAlternative {
        private List<SqlFunction> elseArg = new ArrayList<SqlFunction>();

        public String toString() {
            return "SimpleElseFuncAlternative [elseArg=" + this.elseArg + "]";
        }

        public List<SqlFunction> getElseArg() {
            return this.elseArg;
        }
    }

    public static class SimpleCaseFuncAlternative {
        private final String conditionArg;
        private final List<SqlFunction> consequentArg;

        public SimpleCaseFuncAlternative(String conditionArg) {
            this.conditionArg = conditionArg;
            this.consequentArg = new ArrayList<SqlFunction>();
        }

        public String toString() {
            return "SimpleCaseFuncAlternative [conditionArg=" + this.conditionArg + ", consequentArg=" + this.consequentArg + "]";
        }

        public String getConditionArg() {
            return this.conditionArg;
        }

        public List<SqlFunction> getConsequentArg() {
            return this.consequentArg;
        }
    }
}

