/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.crypto;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.crypto.AbstractCryptoFunction;
import com.oceanbase.tools.loaddump.control.function.crypto.TextEncoding;
import com.oceanbase.tools.loaddump.utils.SecurityUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Base64;
import org.apache.commons.codec.binary.Hex;

public class SM4DecryptFunction
extends AbstractCryptoFunction {
    public SM4DecryptFunction(String key, String encoding) {
        super(key, encoding);
    }

    public SM4DecryptFunction(String key) {
        super(key);
    }

    @Override
    public String getName() {
        return SqlFunctions.SM4_DECRYPT.name();
    }

    @Override
    public String invoke(String ... varargs) {
        String val = varargs[0];
        if (StringUtils.isEmpty(val)) {
            return val;
        }
        try {
            byte[] cipherBytes = this.encoding == TextEncoding.BASE64 ? Base64.getDecoder().decode(val) : Hex.decodeHex((String)val);
            return new String(SecurityUtils.decryptSM4(cipherBytes, this.key));
        }
        catch (Exception e) {
            throw new RuntimeException("SM4 decryption failed.", e);
        }
    }
}

