/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.crypto;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.crypto.AbstractCryptoFunction;
import com.oceanbase.tools.loaddump.control.function.crypto.TextEncoding;
import com.oceanbase.tools.loaddump.utils.SecurityUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Base64;
import org.apache.commons.codec.binary.Hex;

public class SM4EncryptFunction
extends AbstractCryptoFunction {
    public SM4EncryptFunction(String key, String encoding) {
        super(key, encoding);
    }

    public SM4EncryptFunction(String key) {
        super(key);
    }

    @Override
    public String getName() {
        return SqlFunctions.SM4_ENCRYPT.name();
    }

    @Override
    public String invoke(String ... varargs) {
        String val = varargs[0];
        if (StringUtils.isEmpty(val)) {
            return val;
        }
        try {
            byte[] res = SecurityUtils.encryptSM4(val.getBytes(), this.key);
            if (this.encoding == TextEncoding.BASE64) {
                return Base64.getEncoder().encodeToString(res);
            }
            return Hex.encodeHexString((byte[])res);
        }
        catch (Exception e) {
            throw new RuntimeException("SM4 encryption failed.", e);
        }
    }
}

