/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.date;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CurTimeFunction
extends AbstractBuiltinFunction {
    private static final String TIME_PATTERN = "HH:mm:ss";
    private final DateTimeFormatter formatter;

    public CurTimeFunction(int fsp) {
        Preconditions.checkArgument((fsp > -1 ? 1 : 0) != 0, (Object)"Invalid precision for curtime(fsp). Valid: [0,6]");
        Preconditions.checkArgument((fsp < 7 ? 1 : 0) != 0, (Object)"Too-big precision 7 specified for 'curtime'. Maximum is 6.");
        String pattern = fsp > 0 ? "HH:mm:ss." + Stream.iterate(0, i -> i + 1).limit(fsp).map(e -> "S").collect(Collectors.joining("")) : TIME_PATTERN;
        this.formatter = DateTimeFormatter.ofPattern(pattern);
    }

    @Override
    public String invoke(String ... varargs) {
        return this.formatter.format(LocalDateTime.now());
    }

    @Override
    public String getName() {
        return SqlFunctions.CURTIME.name();
    }
}

