/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.date;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class DateAddFunction
extends AbstractBuiltinFunction {
    private final int count;
    private final String dateUnit;
    private final DateTimeFormatter dateFormatter;

    public DateAddFunction(int count, String dateTimeUnit, String datePattern) {
        this.count = count;
        this.dateUnit = dateTimeUnit;
        this.dateFormatter = StringUtils.isEmpty(datePattern) ? Constants.DEFAULT_MYSQL_DATE_FORMATTER : DateTimeFormatter.ofPattern(datePattern);
    }

    @Override
    public String getName() {
        return SqlFunctions.DATE_ADD.name();
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs[0] == null) {
            return null;
        }
        return this.dateAdd(LocalDate.parse(varargs[0], this.dateFormatter));
    }

    private String dateAdd(LocalDate datetime) {
        String datetimeField;
        if (datetime == null) {
            return null;
        }
        switch (datetimeField = this.dateUnit.toUpperCase()) {
            case "YEAR": {
                return datetime.plusYears(this.count).format(this.dateFormatter);
            }
            case "MONTH": {
                return datetime.plusMonths(this.count).format(this.dateFormatter);
            }
            case "WEEK": {
                return datetime.plusWeeks(this.count).format(this.dateFormatter);
            }
            case "DAY": {
                return datetime.plusDays(this.count).format(this.dateFormatter);
            }
        }
        throw new IllegalArgumentException("Invalid date unit for `DATE_ADD`");
    }
}

