/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.date;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;

public class DateDiffFunction
extends AbstractBuiltinFunction {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final String expr1;
    private final String expr2;

    public DateDiffFunction(String expr1, String expr2) {
        this.expr1 = expr1;
        this.expr2 = expr2;
    }

    @Override
    public String invoke(String ... varargs) {
        if (this.expr1 == null || this.expr2 == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(this.expr1), (Object)"Invalid expr1 for 'datediff'.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(this.expr2), (Object)"Invalid expr2 for 'datediff'.");
        String arg1 = this.expr1;
        String arg2 = this.expr2;
        int idx1 = arg1.indexOf(32);
        int idx2 = arg2.indexOf(32);
        arg1 = idx1 > -1 ? arg1.substring(0, idx1) : arg1;
        arg2 = idx2 > -1 ? arg2.substring(0, idx2) : arg2;
        LocalDate ld1 = LocalDate.parse(arg1, DATE_FORMATTER);
        LocalDate ld2 = LocalDate.parse(arg2, DATE_FORMATTER);
        return String.valueOf(Period.between(ld2, ld1).getDays());
    }

    @Override
    public String getName() {
        return SqlFunctions.DATE_DIFF.name();
    }
}

