/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.date;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class DateTruncFunction
extends AbstractBuiltinFunction {
    private final String dateUnit;
    private final DateTimeFormatter dateFormatter;

    public DateTruncFunction(String dateTimeUnit, String datePattern) {
        this.dateUnit = dateTimeUnit;
        this.dateFormatter = StringUtils.isEmpty(datePattern) ? Constants.DEFAULT_MYSQL_DATE_FORMATTER : DateTimeFormatter.ofPattern(datePattern);
    }

    @Override
    public String getName() {
        return SqlFunctions.DATE_TRUNC.name();
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs[0] == null) {
            return null;
        }
        return this.dateTrunc(LocalDate.parse(varargs[0], this.dateFormatter));
    }

    private String dateTrunc(LocalDate date) {
        if (date == null) {
            return null;
        }
        String datetimeField = this.dateUnit.toUpperCase();
        int year = date.getYear();
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        switch (datetimeField) {
            case "YEAR": {
                month = 1;
                day = 1;
                break;
            }
            case "MONTH": {
                day = 1;
                break;
            }
            case "DAY": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid datetime unit for `DATE_TRUNC`");
            }
        }
        return LocalDate.of(year, month, day).format(this.dateFormatter);
    }
}

