/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.date;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class TimestampAddFunction
extends AbstractBuiltinFunction {
    private final DateTimeFormatter dateFormatter;
    private final int count;
    private final String dateTimeUnit;

    public TimestampAddFunction(int count, String dateTimeUnit, String datePattern) {
        this.count = count;
        this.dateTimeUnit = dateTimeUnit;
        this.dateFormatter = StringUtils.isEmpty(datePattern) ? Constants.DEFAULT_DATETIME_FORMATTER : DateTimeFormatter.ofPattern(datePattern);
    }

    @Override
    public String getName() {
        return SqlFunctions.TIMESTAMP_ADD.name();
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs[0] == null) {
            return null;
        }
        return this.timestampAdd(LocalDateTime.parse(varargs[0], this.dateFormatter));
    }

    private String timestampAdd(LocalDateTime datetime) {
        LocalDateTime ldt;
        String datetimeField;
        if (datetime == null) {
            return null;
        }
        switch (datetimeField = this.dateTimeUnit.toUpperCase()) {
            case "YEAR": {
                ldt = datetime.plusYears(this.count);
                break;
            }
            case "MONTH": {
                ldt = datetime.plusMonths(this.count);
                break;
            }
            case "WEEK": {
                ldt = datetime.plusWeeks(this.count);
                break;
            }
            case "DAY": {
                ldt = datetime.plusDays(this.count);
                break;
            }
            case "HOUR": {
                ldt = datetime.plusHours(this.count);
                break;
            }
            case "MINUTE": {
                ldt = datetime.plusMinutes(this.count);
                break;
            }
            case "SECOND": {
                ldt = datetime.plusSeconds(this.count);
                break;
            }
            case "MILLISECOND": {
                ldt = datetime.plusNanos((long)this.count * 1000000L);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid datetime unit for `TIMESTAMP_ADD`");
            }
        }
        return ldt.format(this.dateFormatter);
    }
}

