/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.date;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class TimestampTruncFunction
extends AbstractBuiltinFunction {
    private final String dateTimeUnit;
    private final DateTimeFormatter dateFormatter;

    public TimestampTruncFunction(String dateTimeUnit, String datePattern) {
        this.dateTimeUnit = dateTimeUnit;
        this.dateFormatter = StringUtils.isEmpty(datePattern) ? Constants.DEFAULT_DATETIME_FORMATTER : DateTimeFormatter.ofPattern(datePattern);
    }

    @Override
    public String getName() {
        return SqlFunctions.TIMESTAMP_TRUNC.name();
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs[0] == null) {
            return null;
        }
        return this.timestampTrunc(LocalDateTime.parse(varargs[0], this.dateFormatter));
    }

    private String timestampTrunc(LocalDateTime datetime) {
        if (datetime == null) {
            return null;
        }
        String datetimeField = this.dateTimeUnit.toUpperCase();
        int year = datetime.getYear();
        int month = datetime.getMonthValue();
        int day = datetime.getDayOfMonth();
        int hour = datetime.getHour();
        int minute = datetime.getMinute();
        int second = datetime.getSecond();
        switch (datetimeField) {
            case "YEAR": {
                month = 1;
                day = 1;
                hour = 0;
                minute = 0;
                second = 0;
                break;
            }
            case "MONTH": {
                day = 1;
                hour = 0;
                minute = 0;
                second = 0;
                break;
            }
            case "DAY": {
                hour = 0;
                minute = 0;
                second = 0;
                break;
            }
            case "HOUR": {
                minute = 0;
                second = 0;
                break;
            }
            case "MINUTE": {
                second = 0;
                break;
            }
            case "SECOND": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid datetime unit for `DATE_TRUNC`");
            }
        }
        return LocalDateTime.of(year, month, day, hour, minute, second).format(this.dateFormatter);
    }
}

