/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.date;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToTimestampFunction
extends AbstractBuiltinFunction {
    private static final Logger log = LoggerFactory.getLogger(ToTimestampFunction.class);
    protected final String originPattern;
    protected final String targetPattern;

    public ToTimestampFunction(String originPattern) {
        this(originPattern, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public ToTimestampFunction(String originPattern, String targetPattern) {
        this.originPattern = originPattern;
        this.targetPattern = targetPattern;
    }

    @Override
    public String getName() {
        return SqlFunctions.TO_TIMESTAMP.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return this.toTimestamp(varargs == null ? null : varargs[0]);
    }

    private String toTimestamp(String value) {
        if (value == null) {
            return null;
        }
        try {
            if (this.targetPattern.contains("SSSS")) {
                String newOriginPattern = this.originPattern;
                if (this.originPattern.contains("yyyyMMddHHmmss")) {
                    value = this.parseFormat(value);
                    newOriginPattern = "yyyy-MM-dd HH:mm:ss." + this.originPattern.substring(14);
                }
                DateTimeFormatter originFormatter = DateTimeFormatter.ofPattern(newOriginPattern);
                DateTimeFormatter targetFormatter = DateTimeFormatter.ofPattern(this.targetPattern);
                LocalDateTime dateTime = LocalDateTime.parse(value.trim(), originFormatter);
                return dateTime.format(targetFormatter);
            }
            String[] parsePatterns = new String[]{this.originPattern};
            Date date = DateUtils.parseDate((String)value.trim(), (String[])parsePatterns);
            return new SimpleDateFormat(this.targetPattern).format(date);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String parseFormat(String value) {
        String dateTimeStr = value.trim();
        String datePart = dateTimeStr.substring(0, 14);
        String microsecondPart = dateTimeStr.substring(14);
        try {
            Date date = DateUtils.parseDate((String)datePart, (String[])new String[]{"yyyyMMddHHmmss"});
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date) + "." + microsecondPart;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getOriginPattern() {
        return this.originPattern;
    }

    public String getTargetPattern() {
        return this.targetPattern;
    }
}

