/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.date;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class YearFunction
extends AbstractBuiltinFunction {
    private final DateTimeFormatter dateFormatter;

    public YearFunction(String datePattern) {
        this.dateFormatter = StringUtils.isEmpty(datePattern) ? Constants.DEFAULT_DATETIME_FORMATTER : DateTimeFormatter.ofPattern(datePattern);
    }

    @Override
    public String getName() {
        return SqlFunctions.YEAR.name();
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs[0] == null) {
            return null;
        }
        return this.year(LocalDateTime.parse(varargs[0], this.dateFormatter));
    }

    private String year(LocalDateTime datetime) {
        return String.valueOf(datetime.toLocalDate().getYear());
    }
}

