/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.mask;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public class MaskFunction
extends AbstractBuiltinFunction {
    private final String upperMask;
    private final String lowerMask;
    private final String numMask;

    public MaskFunction() {
        this("X", "x", "n");
    }

    public MaskFunction(String upperMask) {
        this(upperMask, "x", "n");
    }

    public MaskFunction(String upperMask, String lowerMask) {
        this(upperMask, lowerMask, "n");
    }

    public MaskFunction(String upperMask, String lowerMask, String numMask) {
        this.upperMask = upperMask;
        this.lowerMask = lowerMask;
        this.numMask = numMask;
    }

    @Override
    public String getName() {
        return SqlFunctions.MASK.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return this.mask(varargs == null ? null : varargs[0]);
    }

    private String mask(String origin) {
        if (StringUtils.isEmpty(origin)) {
            return origin;
        }
        StringBuilder sb = new StringBuilder(origin.length());
        for (char c : origin.toCharArray()) {
            if (Character.isUpperCase(c)) {
                sb.append(this.upperMask);
                continue;
            }
            if (Character.isLowerCase(c)) {
                sb.append(this.lowerMask);
                continue;
            }
            if (Character.isDigit(c)) {
                sb.append(this.numMask);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

