/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.mask;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public class MaskShowLastNFunction
extends AbstractBuiltinFunction {
    private final String upperMask;
    private final String lowerMask;
    private final String numMask;
    private final int lastN;

    public MaskShowLastNFunction() {
        this("X", "x", "n", 0);
    }

    public MaskShowLastNFunction(String upperMask) {
        this(upperMask, "x", "n", 0);
    }

    public MaskShowLastNFunction(String upperMask, String lowerMask) {
        this(upperMask, lowerMask, "n", 0);
    }

    public MaskShowLastNFunction(String upperMask, String lowerMask, String numMask) {
        this(upperMask, lowerMask, numMask, 0);
    }

    public MaskShowLastNFunction(String upperMask, String lowerMask, String numMask, int lastN) {
        this.upperMask = upperMask;
        this.lowerMask = lowerMask;
        this.numMask = numMask;
        this.lastN = lastN;
    }

    @Override
    public String getName() {
        return SqlFunctions.MASK_SHOW_LAST_N_FUNCTION.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return this.maskShowLastN(varargs == null ? null : varargs[0]);
    }

    private String maskShowLastN(String origin) {
        if (StringUtils.isEmpty(origin) || this.lastN < 0) {
            return origin;
        }
        StringBuilder sb = new StringBuilder(origin.length());
        int n = Math.min(this.lastN, origin.length());
        for (int i = 0; i < origin.length() - n; ++i) {
            char c = origin.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append(this.upperMask);
                continue;
            }
            if (Character.isLowerCase(c)) {
                sb.append(this.lowerMask);
                continue;
            }
            if (Character.isDigit(c)) {
                sb.append(this.numMask);
                continue;
            }
            sb.append(c);
        }
        return sb.append(origin.substring(origin.length() - n)).toString();
    }
}

