/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.number;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.control.function.Invokers;
import com.oceanbase.tools.loaddump.control.function.SqlFunction;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathemFunction
extends AbstractBuiltinFunction {
    private static final Logger log = LoggerFactory.getLogger(MathemFunction.class);
    public static final String MUL_SYMBOL = "*";
    public static final String ADD_SYMBOL = "+";
    public static final String MIN_SYMBOL = "-";
    public static final String DIV_SYMBOL = "/";
    public static final String MOD_SYMBOL = "%";
    public static final String MOD_TOKEN = "MOD";
    public static final String DIV_TOKEN = "DIV";
    private List<SqlFunction> leftExpr;
    private String mathOperator;
    private List<SqlFunction> rightExpr;

    public MathemFunction(String mathOperator) {
        this.mathOperator = mathOperator;
        this.leftExpr = new ArrayList<SqlFunction>();
        this.rightExpr = new ArrayList<SqlFunction>();
    }

    @Override
    public String getName() {
        return SqlFunctions.MATH.name();
    }

    @Override
    public String invoke(String ... varargs) {
        String argument = varargs == null ? null : varargs[0];
        String left = Invokers.invoke0(this.leftExpr, argument);
        String right = Invokers.invoke0(this.rightExpr, argument);
        if (left == null || right == null) {
            return null;
        }
        String operator = this.getMathOperator().trim().toUpperCase(Locale.getDefault());
        try {
            if (MUL_SYMBOL.equals(operator)) {
                return String.valueOf(Long.parseLong(left) * Long.parseLong(right));
            }
            if (DIV_SYMBOL.equals(operator) || DIV_TOKEN.equals(operator)) {
                return String.valueOf(Long.parseLong(left) / Long.parseLong(right));
            }
            if (MOD_SYMBOL.equals(operator) || MOD_TOKEN.equals(operator)) {
                return String.valueOf(Long.parseLong(left) % Long.parseLong(right));
            }
            if (ADD_SYMBOL.equals(operator)) {
                return String.valueOf(Long.parseLong(left) + Long.parseLong(right));
            }
            if (MIN_SYMBOL.equals(operator)) {
                return String.valueOf(Long.parseLong(left) - Long.parseLong(right));
            }
            log.warn("Unsupported mathem operator: {} {} {}", new Object[]{left, operator, right});
            return argument;
        }
        catch (NumberFormatException e) {
            log.error("Number format failed. {} {} {}. Error: {}", new Object[]{left, operator, right, ExceptionUtils.getRootCauseMessage(e)});
            return null;
        }
    }

    public List<SqlFunction> getLeftExpr() {
        return this.leftExpr;
    }

    public String getMathOperator() {
        return this.mathOperator;
    }

    public List<SqlFunction> getRightExpr() {
        return this.rightExpr;
    }
}

