/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.number;

import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class TruncFunction
extends AbstractBuiltinFunction {
    private final int decimal;

    public TruncFunction(int decimal) {
        this.decimal = decimal;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs == null || varargs.length == 0 || StringUtils.isBlank(varargs[0])) {
            return null;
        }
        try {
            BigDecimal number = new BigDecimal(varargs[0]);
            return this.trunc(number, this.decimal);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String trunc(BigDecimal number, int decimal) {
        if (decimal >= 0) {
            number = number.setScale(decimal, RoundingMode.DOWN);
            return number.toPlainString();
        }
        double factor = Math.pow(10.0, -decimal);
        return String.valueOf((long)(Math.floor((double)number.longValue() / factor) * factor));
    }
}

