/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.string;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertFunction
extends AbstractBuiltinFunction {
    private static final Logger log = LoggerFactory.getLogger(ConvertFunction.class);
    private String sourceCharset;
    private String destCharset;

    public ConvertFunction() {
    }

    public ConvertFunction(String destCharset) {
        this(null, destCharset);
    }

    public ConvertFunction(String sourceCharset, String destCharset) {
        this.sourceCharset = sourceCharset;
        this.destCharset = destCharset;
    }

    @Override
    public String getName() {
        return SqlFunctions.CONVERT.name();
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs == null || varargs[0] == null) {
            return null;
        }
        if (StringUtils.isBlank(this.destCharset)) {
            log.warn("The required field dest charset cannot be null");
            return null;
        }
        if (StringUtils.isBlank(this.sourceCharset)) {
            this.sourceCharset = Charset.defaultCharset().displayName();
        }
        try {
            return new String(varargs[0].getBytes(this.sourceCharset), this.destCharset);
        }
        catch (Exception e) {
            log.error("Convert string failed: {} to {}. Error: {}", new Object[]{this.sourceCharset, this.destCharset, ExceptionUtils.getRootCauseMessage(e)});
            return null;
        }
    }

    public void setSourceCharset(String sourceCharset) {
        this.sourceCharset = sourceCharset;
    }

    public void setDestCharset(String destCharset) {
        this.destCharset = destCharset;
    }
}

