/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.string;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public class LpadFunction
extends AbstractBuiltinFunction {
    private final int paddedLength;
    private String padString = " ";

    public LpadFunction(int paddedLength) {
        this(paddedLength, " ");
    }

    public LpadFunction(int paddedLength, String padString) {
        this.paddedLength = paddedLength;
        this.padString = padString;
    }

    @Override
    public String getName() {
        return SqlFunctions.LPAD.name();
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs == null || varargs[0] == null) {
            return null;
        }
        return this.lpad(varargs[0]);
    }

    private String lpad(String value) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        if (this.paddedLength <= length) {
            return value.substring(0, this.paddedLength);
        }
        return StringUtils.leftPad((String)value, (int)this.paddedLength, (String)this.padString);
    }

    public void setPadString(String padString) {
        this.padString = padString;
    }
}

