/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.string;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.control.parser.SyntaxException;
import com.oceanbase.tools.loaddump.utils.ArrayUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public class LpadbFunction
extends AbstractBuiltinFunction {
    private final int paddedLength;
    private final String padString;

    public LpadbFunction(int paddedLength) {
        this(paddedLength, " ");
    }

    public LpadbFunction(int paddedLength, String padString) {
        this.paddedLength = paddedLength;
        this.padString = padString;
    }

    @Override
    public String getName() {
        return SqlFunctions.LPADB.name();
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs == null || varargs[0] == null || this.paddedLength < 1) {
            return null;
        }
        String padString = this.padString;
        if (StringUtils.isEmpty(padString)) {
            padString = " ";
        } else if (padString.getBytes().length > 1) {
            throw new SyntaxException("The pad string must be a single byte character");
        }
        int paddedSize = this.paddedLength - varargs[0].getBytes().length;
        if (paddedSize == 0) {
            return varargs[0];
        }
        if (paddedSize < 0) {
            varargs[0] = ArrayUtils.truncateb(varargs[0], this.paddedLength, padString.charAt(0));
            paddedSize = this.paddedLength - varargs[0].getBytes().length;
            if (paddedSize == 0) {
                return varargs[0];
            }
        }
        StringBuilder sb = new StringBuilder(this.paddedLength);
        for (int i = 0; i < paddedSize; ++i) {
            sb.append(padString);
        }
        return sb.append(varargs[0]).toString();
    }
}

