/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.string;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import java.util.Arrays;

public class LtrimFunction
extends AbstractBuiltinFunction {
    private String trimString = " ";

    public LtrimFunction() {
        this(" ");
    }

    public LtrimFunction(String trimString) {
        this.trimString = trimString;
    }

    @Override
    public String getName() {
        return SqlFunctions.LTRIM.name();
    }

    @Override
    public String invoke(String ... varargs) {
        if (varargs == null || varargs[0] == null) {
            return null;
        }
        return this.ltrim(varargs[0]);
    }

    private String ltrim(String value) {
        char key;
        int beginIndex;
        if (value == null) {
            return value;
        }
        if (this.trimString == null) {
            this.trimString = " ";
        }
        char[] trimSet = this.trimString.toCharArray();
        int length = value.length();
        for (beginIndex = 0; beginIndex < length && Arrays.binarySearch(trimSet, key = value.charAt(beginIndex)) >= 0; ++beginIndex) {
        }
        return value.substring(beginIndex);
    }

    public void setTrimString(String trimString) {
        this.trimString = trimString;
    }
}

