/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.string;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.control.function.SqlFunction;
import java.util.ArrayList;
import java.util.List;

public class ReplaceFunction
extends AbstractBuiltinFunction {
    private String replacement;
    private final List<SqlFunction> originFunc = new ArrayList<SqlFunction>();
    private final List<SqlFunction> searchFunc = new ArrayList<SqlFunction>();

    @Override
    public String getName() {
        return SqlFunctions.REPLACE.name();
    }

    @Override
    public String invoke(String ... varargs) {
        int i;
        if (varargs == null) {
            return null;
        }
        String originString = varargs[0];
        String searchString = "";
        for (i = this.originFunc.size() - 1; i >= 0; --i) {
            if (i == this.originFunc.size() - 1) {
                originString = "";
            }
            originString = this.originFunc.get(i).invoke(originString);
        }
        for (i = this.searchFunc.size() - 1; i >= 0; --i) {
            searchString = this.searchFunc.get(i).invoke(searchString);
        }
        return this.replace(originString, searchString);
    }

    private String replace(String value, String searchString) {
        if (value == null || searchString == null || this.replacement == null) {
            return null;
        }
        if (!"".equals(value)) {
            if ("".equals(searchString)) {
                return value;
            }
            if ("\\r".equals(searchString) || "\\n".equals(searchString)) {
                return value.replaceAll(searchString, this.replacement);
            }
        }
        return value.replace(searchString, this.replacement);
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public List<SqlFunction> getOriginFunc() {
        return this.originFunc;
    }

    public List<SqlFunction> getSearchFunc() {
        return this.searchFunc;
    }
}

