/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.function.string;

import com.oceanbase.tools.loaddump.control.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.control.function.AbstractBuiltinFunction;

public class SubstrFunction
extends AbstractBuiltinFunction {
    private Integer startPosition = 1;
    private Integer substringLength = null;

    public SubstrFunction(int startPosition) {
        this.startPosition = startPosition;
    }

    public SubstrFunction(int startPosition, int substringLength) {
        this.startPosition = startPosition;
        this.substringLength = substringLength;
    }

    @Override
    public String getName() {
        return SqlFunctions.SUBSTR.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return varargs == null ? null : this.substr(varargs[0]);
    }

    private String substr(String value) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        int startPosition = this.getStartPosition();
        if (startPosition > length) {
            return null;
        }
        startPosition = startPosition < 0 ? (startPosition += length) : --startPosition;
        Integer substringLength = this.getSubstringLength();
        if (substringLength == null) {
            return value.substring(startPosition);
        }
        if (substringLength < 1) {
            return null;
        }
        int endIndex = startPosition + substringLength;
        if (endIndex > length) {
            endIndex = length;
        }
        StringBuilder temp = new StringBuilder();
        for (int i = startPosition; i < endIndex; ++i) {
            temp.append(value.charAt(i));
        }
        return temp.toString();
    }

    public Integer getStartPosition() {
        return this.startPosition == 0 ? 1 : this.startPosition;
    }

    public void setStartPosition(Integer startPosition) {
        this.startPosition = startPosition;
    }

    public Integer getSubstringLength() {
        return this.substringLength;
    }

    public void setSubstringLength(Integer substringLength) {
        this.substringLength = substringLength;
    }
}

