/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.control.predicate;

import com.oceanbase.tools.loaddump.control.function.Invokers;
import com.oceanbase.tools.loaddump.control.function.SqlFunction;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinCompPredicate
implements Predicate<String> {
    private static final Logger log = LoggerFactory.getLogger(BinCompPredicate.class);
    private List<SqlFunction> leftPred = new ArrayList<SqlFunction>();
    private String compareOperator;
    private List<SqlFunction> rightPred;

    public BinCompPredicate(String compareOperator) {
        this.compareOperator = compareOperator;
        this.rightPred = new ArrayList<SqlFunction>();
    }

    @Override
    public boolean test(String t) {
        String left = Invokers.invoke0(this.getLeftPred(), t);
        String right = Invokers.invoke0(this.getRightPred(), t);
        String operator = this.getCompareOperator().trim();
        if ("=".equals(operator)) {
            return StringUtils.equals(left, right);
        }
        if ("<>".equals(operator) || "!=".equals(operator)) {
            return StringUtils.notEquals(left, right);
        }
        if (left == null || right == null) {
            return false;
        }
        try {
            if (">".equals(operator)) {
                return Long.parseLong(left) > Long.parseLong(right);
            }
            if ("<".equals(operator)) {
                return Long.parseLong(left) < Long.parseLong(right);
            }
            if ("<=".equals(operator)) {
                return Long.parseLong(left) <= Long.parseLong(right);
            }
            if (">=".equals(operator)) {
                return Long.parseLong(left) >= Long.parseLong(right);
            }
            log.warn("Unsupported compare operator: {} {} {}", new Object[]{left, operator, right});
            return false;
        }
        catch (NumberFormatException e) {
            log.error("Number format failed: {} {} {}. Error: {}", new Object[]{left, operator, right, ExceptionUtils.getRootCauseMessage(e)});
            return false;
        }
    }

    public List<SqlFunction> getLeftPred() {
        return this.leftPred;
    }

    public void setLeftPred(List<SqlFunction> leftPred) {
        this.leftPred = leftPred;
    }

    public String getCompareOperator() {
        return this.compareOperator;
    }

    public void setCompareOperator(String compareOperator) {
        this.compareOperator = compareOperator;
    }

    public List<SqlFunction> getRightPred() {
        return this.rightPred;
    }

    public void setRightPred(List<SqlFunction> rightPred) {
        this.rightPred = rightPred;
    }
}

