/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.directpath;

import com.alipay.oceanbase.rpc.direct_load.ObDirectLoadBucket;
import com.alipay.oceanbase.rpc.direct_load.exception.ObDirectLoadException;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.directpath.AbstractRestrictedPreparedStatement;
import com.oceanbase.tools.loaddump.directpath.DirectPathConnection;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;

public class DirectPathPreparedStatement
extends AbstractRestrictedPreparedStatement {
    private ObDirectLoadBucket bucket;
    private final DirectPathConnection conn;
    private final Map<Integer, ObObj> parameters;
    public static final int[] EMPTY_ARRAY = new int[0];

    public DirectPathPreparedStatement(DirectPathConnection conn) {
        this.conn = conn;
        this.parameters = new HashMap<Integer, ObObj>();
        this.bucket = new ObDirectLoadBucket();
    }

    @Override
    public DirectPathConnection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkRange();
        ObObj[] objObjArray = new ObObj[this.parameters.size()];
        for (Map.Entry<Integer, ObObj> entry : this.parameters.entrySet()) {
            objObjArray[entry.getKey().intValue() - 1] = entry.getValue();
        }
        this.addBatch(objObjArray);
    }

    private void checkRange() {
        OptionalInt optionalInt = this.parameters.keySet().stream().mapToInt(e -> e).max();
        int parameterIndex = optionalInt.orElseThrow(() -> new IllegalArgumentException("No parameter index found"));
        Preconditions.checkArgument((parameterIndex == this.parameters.size() ? 1 : 0) != 0, (String)"Parameter index(%s) is unmatched with value list(%s).", (int)parameterIndex, (int)this.parameters.size());
    }

    public void addBatch(List<?> values) {
        this.addBatch(this.createObObjArray(values));
    }

    public void addBatch(List<?> values, List<String> fieldNameList, int tableColumnCount, Map<Integer, Integer> targetToSourceIndexMap) {
        if (CollectionUtils.isEmpty(fieldNameList)) {
            this.addBatch(values);
            return;
        }
        ObObj[] array = new ObObj[tableColumnCount];
        for (int i = 0; i < tableColumnCount; ++i) {
            Integer sourceIndex = targetToSourceIndexMap.get(i);
            array[i] = sourceIndex == null ? this.createDefaultValueObObj() : this.createObObj(values.get(sourceIndex));
        }
        this.addBatch(array);
    }

    public void addBatch(Object[] values) {
        this.addBatch(this.createObObjArray(values));
    }

    private void addBatch(ObObj[] arr) {
        Preconditions.checkArgument((arr != null && arr.length > 0 ? 1 : 0) != 0, (Object)"Input values is null");
        try {
            this.bucket.addRow(arr);
        }
        catch (ObDirectLoadException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.bucket.isEmpty() ? EMPTY_ARRAY : this.conn.insert(this.bucket);
    }

    @Override
    public void clearBatch() {
        this.parameters.clear();
        this.bucket = new ObDirectLoadBucket();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    @Override
    public boolean isOracleMode() {
        return false;
    }

    @Override
    protected void setParameter(int parameterIndex, ObObj obObj) throws SQLException {
        Preconditions.checkArgument((parameterIndex > 0 ? 1 : 0) != 0, (Object)"Parameter index should start from 1");
        this.parameters.put(parameterIndex, obObj);
    }
}

