/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.SessionManager;
import com.oceanbase.tools.loaddump.common.TaskContext;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.enums.State;
import com.oceanbase.tools.loaddump.common.exception.NoTaskGeneratedException;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProvider;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.DumpProgress;
import com.oceanbase.tools.loaddump.common.model.Progress;
import com.oceanbase.tools.loaddump.common.model.RuntimeMetrics;
import com.oceanbase.tools.loaddump.common.model.Summary;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.thread.ExecutorTemplate;
import com.oceanbase.tools.loaddump.common.thread.NamedThreadFactory;
import com.oceanbase.tools.loaddump.dumper.IDumper;
import com.oceanbase.tools.loaddump.dumper.task.AbstractDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.generator.DumpTaskGenerator;
import com.oceanbase.tools.loaddump.dumper.task.record.RecordDumpTask;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.SerializeUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDumper<T extends AbstractDumpTask>
extends TaskContext
implements IDumper {
    private static final Logger log = LoggerFactory.getLogger(AbstractDumper.class);
    protected State state = State.INITIAL;
    protected Meter meter;
    protected ServerMode serverMode;
    protected AtomicBoolean supervisor;
    protected DumpParameter parameter;
    protected ConnectionKey connectionKey;
    protected SessionManager sessionManager;
    protected MetadataProvider metadataProvider;
    protected RuntimeMetrics runtimeMetrics;
    protected ExecutorService defaultExecutor;
    protected final List<TaskDetail> taskDetailList;
    private final List<T> dumpTasks = new ArrayList<T>();

    public AbstractDumper(DumpParameter parameter) {
        this.parameter = parameter;
        this.connectionKey = parameter.getConnectionKey();
        this.sessionManager = parameter.getConnectionKey().getSessionManager();
        this.metadataProvider = parameter.getConnectionKey().getMetadataProvider();
        this.taskDetailList = new ArrayList<TaskDetail>(16);
        this.supervisor = new AtomicBoolean(true);
        this.serverMode = parameter.getDatabase().getServerMode();
    }

    @Override
    public IDumper prepare() throws Exception {
        ExecutorTemplate.setPoolSize(this.parameter.getThreads());
        if (this.parameter.isRetry()) {
            String checkpointPath = this.parameter.getCheckpointPath();
            File checkpoint = new File(checkpointPath);
            if (!(this.parameter.isIncludeDdl() || checkpoint.exists() && !checkpoint.isDirectory())) {
                throw new FileNotFoundException("File: \"" + checkpointPath + "\" is missing");
            }
            List<AbstractDumpTask> persistTasks = SerializeUtils.deserializeListByKryo(checkpointPath);
            if (CollectionUtils.isEmpty(persistTasks)) {
                throw new IllegalStateException("No dump tasks are recovered from the checkpoint file: \"" + checkpointPath + "\"");
            }
            this.prepareForRetry(persistTasks);
        }
        this.state = State.PREPARE;
        return this;
    }

    protected abstract void prepareForRetry(List<AbstractDumpTask> var1);

    protected abstract void preDumpTasksSubmitted(ObjectType var1, List<T> var2) throws Exception;

    protected abstract void postDumpTasksSubmitted(ObjectType var1, List<T> var2) throws Exception;

    protected abstract void postAllDumpTasksSubmitted(List<T> var1);

    protected abstract Map<ObjectType, Set<String>> getToBeDumpedObjectType2ObjectNames();

    protected abstract DumpTaskGenerator<T> createDumpTaskGenerator(@NonNull ThreadPoolExecutor var1);

    protected abstract ExecutorService createDumpTaskThreadPool();

    protected abstract List<Set<String>> groupByConcurrentSpec(ObjectType var1, Set<String> var2);

    @Override
    public TaskContext dumpSchemaAsync() throws Exception {
        return this.doDumpAsync();
    }

    @Override
    public TaskContext dumpRecordAsync() throws Exception {
        return this.doDumpAsync();
    }

    @Override
    public RuntimeMetrics getRuntimeMetrics() {
        if (this.runtimeMetrics == null) {
            this.runtimeMetrics = new RuntimeMetrics();
        }
        this.runtimeMetrics.setThroughput(this.meter != null ? this.meter.getThroughput() : 0L);
        this.runtimeMetrics.setMeanThroughputRate(this.meter != null ? this.meter.getMeanThroughputRate() : 0.0);
        this.runtimeMetrics.setProgress(this.getProgress().getProgress());
        this.runtimeMetrics.setCount(this.taskDetailList.stream().mapToLong(TaskDetail::getCount).sum());
        this.runtimeMetrics.setTotal(this.taskDetailList.stream().mapToLong(TaskDetail::getTotal).sum());
        return this.runtimeMetrics;
    }

    @Override
    public Progress getProgress() {
        int totalTasks = this.dumpTasks.size();
        int finishedTasks = this.dumpTasks.stream().filter(AbstractDumpTask::isFinished).mapToInt(t -> 1).sum();
        int runningTasks = totalTasks - finishedTasks;
        int percentage = finishedTasks * 100 / totalTasks;
        return new DumpProgress(finishedTasks, runningTasks, percentage, 0, 0);
    }

    @Override
    public Summary getSummary() {
        return new Summary("All Dump Tasks Finished", this.getAllTaskDetails());
    }

    @Override
    public boolean isThreadPoolAlive() {
        return this.isAlive(this.defaultExecutor);
    }

    @Override
    public boolean isAllTasksFinished() {
        if (CollectionUtils.isEmpty(this.taskDetailList)) {
            log.warn("The task details are empty, please check it....");
            return false;
        }
        return this.getAllTaskDetails().stream().allMatch(TaskDetail::isFinished);
    }

    @Override
    public boolean isAllTasksSuccessed() {
        if (CollectionUtils.isEmpty(this.taskDetailList)) {
            log.warn("The task details are empty, please check it....");
            return false;
        }
        return this.getAllTaskDetails().stream().allMatch(TaskDetail::isSuccess);
    }

    @Override
    public Collection<TaskDetail> getAllTaskDetails() {
        return Collections.unmodifiableCollection(this.taskDetailList);
    }

    @Override
    public Collection<TaskDetail> getFailureTaskDetails() {
        return this.taskDetailList.stream().filter(TaskDetail::isFailure).collect(Collectors.toList());
    }

    @Override
    public void shutdown() throws Exception {
        this.state = State.TERMINATE;
        this.supervisor.compareAndSet(true, false);
        this.shutdownInternal(false, this.defaultExecutor);
    }

    @Override
    public void shutdownNow() throws Exception {
        this.state = State.TERMINATE;
        this.supervisor.compareAndSet(true, false);
        this.shutdownInternal(true, this.defaultExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskContext doDumpAsync() throws Exception {
        Object lock = new Object();
        ThreadPoolExecutor dumpTaskSubmitExecutor = new ThreadPoolExecutor(this.parameter.getThreads(), this.parameter.getThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new NamedThreadFactory("dump-task-submit-"));
        ThreadPoolExecutor dumpTaskGenerateExecutor = new ThreadPoolExecutor(this.parameter.getThreads(), this.parameter.getThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new NamedThreadFactory("dump-task-generate-"));
        try {
            this.checkState();
            this.defaultExecutor = this.createDumpTaskThreadPool();
            DumpTaskGenerator<T> generator = this.createDumpTaskGenerator(dumpTaskGenerateExecutor);
            AtomicLong fileSizeAccumulator = new AtomicLong(0L);
            AtomicInteger recordCountAccumulator = new AtomicInteger(0);
            Map<ObjectType, Set<String>> type2Names = this.getToBeDumpedObjectType2ObjectNames();
            int counter = 0;
            ExecutorCompletionService<List> completionService = new ExecutorCompletionService<List>(dumpTaskSubmitExecutor);
            for (Map.Entry<ObjectType, Set<String>> entry : type2Names.entrySet()) {
                ObjectType objectType = entry.getKey();
                if (entry.getValue().isEmpty()) continue;
                log.info("A total of {} {} need to be dumped.", (Object)entry.getValue().size(), (Object)objectType);
                List<Set<String>> namesList = this.groupByConcurrentSpec(objectType, entry.getValue());
                for (Set<String> names : namesList) {
                    ++counter;
                    completionService.submit(() -> {
                        List dumpTasks = generator.generateDumpTasks(objectType, names);
                        Object object = lock;
                        synchronized (object) {
                            this.initDumpTasks(dumpTasks, fileSizeAccumulator, recordCountAccumulator);
                            this.preDumpTasksSubmitted(objectType, dumpTasks);
                            ArrayList<AbstractDumpTask> submittedTasks = new ArrayList<AbstractDumpTask>();
                            for (AbstractDumpTask dumpTask : dumpTasks) {
                                if (!this.supervisor.get()) continue;
                                submittedTasks.add(dumpTask);
                                this.defaultExecutor.submit(dumpTask);
                            }
                            this.postDumpTasksSubmitted(objectType, submittedTasks);
                        }
                        return dumpTasks;
                    });
                }
            }
            for (int i = 0; i < counter; ++i) {
                this.dumpTasks.addAll((Collection)completionService.take().get());
            }
            if (CollectionUtils.isEmpty(this.dumpTasks)) {
                throw new NoTaskGeneratedException("No tasks were generated. Check cli args and ensure at least one object exists");
            }
            this.postAllDumpTasksSubmitted(this.dumpTasks);
            this.state = State.RUNNING;
            AbstractDumper abstractDumper = this;
            return abstractDumper;
        }
        catch (Exception e) {
            if (!(e instanceof NoTaskGeneratedException)) {
                log.error("Failed to dump.", (Throwable)e);
            }
            Object object = lock;
            synchronized (object) {
                this.shutdownNow();
            }
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw e;
        }
        finally {
            dumpTaskSubmitExecutor.shutdownNow();
            dumpTaskGenerateExecutor.shutdownNow();
        }
    }

    private void initDumpTasks(List<T> dumpTasks, AtomicLong fileSizeAccumulator, AtomicInteger recordCountAccumulator) throws Exception {
        for (AbstractDumpTask dumpTask : dumpTasks) {
            dumpTask.setSupervisor(this.supervisor);
            dumpTask.setTaskDetail(new TaskDetail());
            dumpTask.setCheckpointPath(this.parameter.getCheckpointPath());
            if (dumpTask instanceof RecordDumpTask) {
                ((RecordDumpTask)dumpTask).setCsvFormat(this.parameter.initCsvFormatMap().get(dumpTask.getObjectName()));
                ((RecordDumpTask)dumpTask).setFileSizeAccumulator(fileSizeAccumulator);
                ((RecordDumpTask)dumpTask).setRecordCountAccumulator(recordCountAccumulator);
            }
            dumpTask.initialize(this.parameter);
            this.taskDetailList.add(dumpTask.getTaskDetail());
        }
    }

    private void checkState() {
        Preconditions.checkState((this.state != State.RUNNING ? 1 : 0) != 0, (Object)"It's already running");
        Preconditions.checkState((this.state != State.TERMINATE ? 1 : 0) != 0, (Object)"It has terminated");
        Preconditions.checkState((this.state == State.PREPARE ? 1 : 0) != 0, (Object)"Not prepared");
    }
}

