/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper;

import com.oceanbase.tools.loaddump.common.TaskContext;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.exception.NoTaskGeneratedException;
import com.oceanbase.tools.loaddump.common.model.ColumnInfo;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.DumpProgress;
import com.oceanbase.tools.loaddump.common.model.Progress;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.common.model.datatype.DataType;
import com.oceanbase.tools.loaddump.common.thread.NamedThreadFactory;
import com.oceanbase.tools.loaddump.control.ControlDescription;
import com.oceanbase.tools.loaddump.control.ControlManager;
import com.oceanbase.tools.loaddump.control.function.AbstractUserDefinedFunction;
import com.oceanbase.tools.loaddump.control.function.SqlFunction;
import com.oceanbase.tools.loaddump.dumper.AbstractDumper;
import com.oceanbase.tools.loaddump.dumper.IDumper;
import com.oceanbase.tools.loaddump.dumper.task.AbstractDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.generator.DumpTaskGenerator;
import com.oceanbase.tools.loaddump.dumper.task.generator.RecordDumpTaskGenerator;
import com.oceanbase.tools.loaddump.dumper.task.generator.SnapshotRecordDumpTaskGenerator;
import com.oceanbase.tools.loaddump.dumper.task.record.FileMergeTask;
import com.oceanbase.tools.loaddump.dumper.task.record.RecordDumpTask;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import com.oceanbase.tools.loaddump.dumper.writer.FileWriterManager;
import com.oceanbase.tools.loaddump.metrics.MetricRegistry;
import com.oceanbase.tools.loaddump.metrics.Slf4jReporter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordFileDumper
extends AbstractDumper<RecordDumpTask> {
    private static final Logger log = LoggerFactory.getLogger(RecordFileDumper.class);
    private final FileWriterManager fileWriterManager;
    private final MetricRegistry registry;
    private final boolean fileMergeEnabled;
    private final AtomicInteger remainingTblCounter;
    private final Map<String, FileMergeTask> tableMergeTaskMap;
    private final ExecutorService mergeFilesExecutor;
    private final ScheduledExecutorService logReporterExecutor;
    private final AtomicBoolean anyDumpTaskSubmitted = new AtomicBoolean(false);

    public RecordFileDumper(DumpParameter parameter) {
        super(parameter);
        DataFormat dataFormat = parameter.getDataFormat();
        this.fileMergeEnabled = StorageType.LOCAL_DISK == parameter.getStorageConfig().getStorageType() && (DataFormat.ORC == dataFormat || DataFormat.PAR == dataFormat || DataFormat.isFileFlat(dataFormat) && !parameter.isCompress());
        this.tableMergeTaskMap = new HashMap<String, FileMergeTask>();
        this.fileWriterManager = FileWriterManager.builder().filePath(parameter.getDefaultTableDataPath()).fileName(parameter.getOutputFile()).fileEncoding(parameter.getFileEncoding()).fileSuffix(parameter.getFileSuffixes().get(0)).dataFormat(parameter.getDataFormat()).blockSizeUnit(parameter.getBlockSizeUnit()).blockSize(parameter.getBlockSize()).commitSize(parameter.getCommitSize()).storageConfig(parameter.getStorageConfig()).retainEmptyFile(parameter.isRetainEmptyFiles()).build();
        Set objectNames = this.getToBeDumpedObjectType2ObjectNames().getOrDefault((Object)ObjectType.TABLE, new HashSet());
        this.remainingTblCounter = new AtomicInteger(objectNames.size());
        if (this.fileMergeEnabled && CollectionUtils.isNotEmpty((Collection)objectNames)) {
            int mergeTableCount = objectNames.size();
            this.mergeFilesExecutor = new ThreadPoolExecutor(mergeTableCount, mergeTableCount, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(mergeTableCount), new NamedThreadFactory("dump-file-merge-thread-"));
        } else {
            this.mergeFilesExecutor = null;
        }
        this.logReporterExecutor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("log-reporter-"), new ThreadPoolExecutor.DiscardOldestPolicy());
        this.registry = new MetricRegistry();
        this.meter = this.registry.meter("Dump Performance Monitor: ");
    }

    @Override
    public IDumper prepare() throws Exception {
        this.initControlManager();
        return super.prepare();
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.shutdownInternal(true, this.mergeFilesExecutor);
        this.shutdownInternal(true, this.logReporterExecutor);
        this.fileWriterManager.close();
    }

    @Override
    public void shutdownNow() throws Exception {
        super.shutdownNow();
        this.shutdownInternal(true, this.mergeFilesExecutor);
        this.shutdownInternal(true, this.logReporterExecutor);
        this.fileWriterManager.close();
    }

    @Override
    public TaskContext dumpSchemaAsync() {
        throw new UnsupportedOperationException("Not implement");
    }

    @Override
    public Progress getProgress() {
        Progress progress = super.getProgress();
        if (MapUtils.isEmpty(this.tableMergeTaskMap)) {
            return progress;
        }
        int finishedMergeTaskCount = (int)this.tableMergeTaskMap.entrySet().stream().filter(e -> ((FileMergeTask)e.getValue()).isFinished()).count();
        return new DumpProgress(progress.getFinished(), progress.getRunning(), progress.getProgress(), this.tableMergeTaskMap.size(), finishedMergeTaskCount);
    }

    @Override
    public boolean isAllTasksFinished() {
        return super.isAllTasksFinished() && this.isAllFileMergeTasksFinished();
    }

    @Override
    public void syncTasksStateFinally() {
        if (MapUtils.isEmpty(this.tableMergeTaskMap)) {
            return;
        }
        this.taskDetailList.forEach(e -> {
            if (e.getTaskType() != TaskType.DUMP_RECORD) {
                return;
            }
            FileMergeTask fileMergeTask = this.tableMergeTaskMap.get(e.getObject());
            if (fileMergeTask != null && fileMergeTask.getTaskState() == TaskState.FAILURE) {
                e.setState(TaskState.FAILURE);
                e.setMergeError(fileMergeTask.getErrorMsg());
            }
        });
    }

    @Override
    protected void prepareForRetry(List<AbstractDumpTask> persistTasks) {
        Set<String> unfinishedRecordTaskTables = persistTasks.stream().filter(e -> TaskState.SUCCESS != e.getTaskState() && e instanceof RecordDumpTask).map(AbstractDumpTask::getObjectName).collect(Collectors.toSet());
        if (unfinishedRecordTaskTables.isEmpty()) {
            throw new NoTaskGeneratedException("All the record dump task have already finished, no need to retry");
        }
        this.parameter.removeFinishedTables(unfinishedRecordTaskTables);
        log.info("Found {} non-successful table record dump, tables : {}", (Object)unfinishedRecordTaskTables.size(), unfinishedRecordTaskTables);
    }

    @Override
    protected Map<ObjectType, Set<String>> getToBeDumpedObjectType2ObjectNames() {
        List<String> tableNames;
        Set<String> objectNames = StringUtils.isEmpty((CharSequence)this.parameter.getQuerySql()) ? this.parameter.getDatabase().getTableInfoMap().values().stream().map(TableInfo::getTable).collect(Collectors.toSet()) : (CollectionUtils.isNotEmpty(tableNames = this.parameter.getDatabase().getTableNames()) ? Collections.singleton(tableNames.get(0)) : Collections.singleton("CUSTOM_SQL"));
        return Collections.singletonMap(ObjectType.TABLE, objectNames);
    }

    @Override
    protected DumpTaskGenerator<RecordDumpTask> createDumpTaskGenerator(@NonNull ThreadPoolExecutor executor) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        if (this.parameter.isSnapshot()) {
            return new SnapshotRecordDumpTaskGenerator(this.parameter, this.metadataProvider, executor);
        }
        return new RecordDumpTaskGenerator(this.parameter, executor);
    }

    @Override
    protected ExecutorService createDumpTaskThreadPool() {
        return new ThreadPoolExecutor(this.parameter.getThreads(), this.parameter.getThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new NamedThreadFactory("dump-record-thread-"));
    }

    @Override
    protected List<Set<String>> groupByConcurrentSpec(ObjectType objectType, Set<String> objectNames) {
        return objectNames.stream().map(Collections::singleton).collect(Collectors.toList());
    }

    @Override
    protected void preDumpTasksSubmitted(ObjectType objectType, List<RecordDumpTask> dumpTasks) throws Exception {
        this.initFileWriters(dumpTasks);
        if (this.fileMergeEnabled) {
            Map<String, List<RecordDumpTask>> tableName2RecordDumpTasks = dumpTasks.stream().collect(Collectors.groupingBy(AbstractDumpTask::getObjectName));
            this.registerAndSubmitFileMergeTasks(tableName2RecordDumpTasks);
        }
    }

    @Override
    protected void postDumpTasksSubmitted(ObjectType objectType, List<RecordDumpTask> dumpTasks) {
        Map<ObjectType, Set<String>> type2Names = this.getToBeDumpedObjectType2ObjectNames();
        int total = ((Set)type2Names.getOrDefault((Object)objectType, new HashSet())).size();
        Set tblNames = dumpTasks.stream().map(AbstractDumpTask::getObjectName).collect(Collectors.toSet());
        log.info("{} \"{}\" is dumping, and several objects are waiting. Remain: [{}/{}]", new Object[]{objectType, String.join((CharSequence)", ", tblNames), this.remainingTblCounter.addAndGet(-1 * tblNames.size()), total});
        if (!this.anyDumpTaskSubmitted.get()) {
            this.anyDumpTaskSubmitted.compareAndSet(false, true);
            Slf4jReporter.forRegistry(this.registry).scheduleOn(this.logReporterExecutor).build().start(5L, TimeUnit.SECONDS);
            log.info("Start up the log reporter task succeed.");
        }
    }

    @Override
    protected void postAllDumpTasksSubmitted(List<RecordDumpTask> dumpTasks) {
        log.info("Start {} record dump threads for {} dump tasks finished", (Object)this.parameter.getThreads(), (Object)dumpTasks.size());
    }

    private void registerAndSubmitFileMergeTasks(Map<String, List<RecordDumpTask>> tableName2RecordDumpTasks) {
        tableName2RecordDumpTasks.entrySet().stream().map(entry -> {
            String tableName = (String)entry.getKey();
            List dumpTasks = (List)entry.getValue();
            String realFileName = this.parameter.getOutputFile() == null ? tableName : this.parameter.getOutputFile();
            FileMergeTask fileMergeTask = new FileMergeTask(realFileName, this.fileWriterManager.getBlockSize(), this.fileWriterManager.getBlockRow(), this.supervisor, this.parameter.getFileEncoding(), dumpTasks.size(), ((RecordDumpTask)dumpTasks.get(0)).getOutputDirPath(), this.parameter.getDataFormat(), this.parameter.getFileSuffixes().get(0));
            this.tableMergeTaskMap.put(tableName, fileMergeTask);
            dumpTasks.forEach(dumpTask -> dumpTask.setFileMergeTask(fileMergeTask));
            return fileMergeTask;
        }).forEach(this.mergeFilesExecutor::submit);
    }

    private void initControlManager() {
        ControlManager controlManager = this.parameter.getControlManager();
        if (Objects.isNull(controlManager)) {
            return;
        }
        for (TableInfo tableInfo : this.parameter.getDatabase().getTableInfoMap().values()) {
            String schemaName = tableInfo.getSchema();
            String tableName = tableInfo.getTable();
            for (ColumnInfo columnInfo : tableInfo.getColumnInfoList()) {
                List<SqlFunction> callStacks;
                ControlDescription control;
                String columnName = columnInfo.getColumnName();
                if (this.parameter.isUseRuntimeTableName()) {
                    schemaName = columnInfo.getSchemaName();
                    tableName = columnInfo.getTableName();
                }
                if (Objects.isNull(control = controlManager.getControl(schemaName, tableName, columnName)) || CollectionUtils.isEmpty(callStacks = control.getCallStacks())) continue;
                for (SqlFunction sqlFunction : callStacks) {
                    if (!(sqlFunction instanceof AbstractUserDefinedFunction)) continue;
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("column_name", columnName);
                    paramMap.put("table_name", tableName);
                    paramMap.put("data_type", tableInfo.getColumnType(columnName));
                    ((AbstractUserDefinedFunction)sqlFunction).setParams(paramMap);
                }
            }
        }
    }

    private boolean isAllFileMergeTasksFinished() {
        return MapUtils.isEmpty(this.tableMergeTaskMap) || this.tableMergeTaskMap.entrySet().stream().allMatch(e -> ((FileMergeTask)e.getValue()).isFinished());
    }

    private void initFileWriters(List<RecordDumpTask> dumpTasks) throws Exception {
        Map<String, Long> tableTaskCntMap = dumpTasks.stream().collect(Collectors.groupingBy(AbstractDumpTask::getObjectName, Collectors.counting()));
        for (RecordDumpTask recordDumpTask : dumpTasks) {
            String tableName = recordDumpTask.getObjectName();
            Map<String, DataType> colTypeMap = this.parameter.getDatabase().getTableInfo(recordDumpTask.getObjectName()).getColumnTypeMap();
            try {
                AbstractRollingFileWriterV2 fileWriter = this.fileWriterManager.getFileWriter(tableName, colTypeMap, tableTaskCntMap.get(tableName).intValue());
                recordDumpTask.setFileWriter(fileWriter);
                recordDumpTask.setOutputDirPath(fileWriter.getFilePath());
                recordDumpTask.setMeter(this.meter);
                recordDumpTask.initialize(this.parameter);
            }
            catch (Exception e) {
                log.error("Create file writer for table \"{}\" failed. Reason: {}", (Object)tableName, (Object)e.getMessage());
                throw e;
            }
        }
    }
}

