/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.TaskContext;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.NoTaskGeneratedException;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.common.thread.NamedThreadFactory;
import com.oceanbase.tools.loaddump.dumper.AbstractDumper;
import com.oceanbase.tools.loaddump.dumper.task.AbstractDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.generator.DumpTaskGenerator;
import com.oceanbase.tools.loaddump.dumper.task.generator.SchemaDumpTaskGenerator;
import com.oceanbase.tools.loaddump.dumper.task.schema.AbstractSchemaDumpTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFileDumper
extends AbstractDumper<AbstractSchemaDumpTask> {
    private static final Logger log = LoggerFactory.getLogger(SchemaFileDumper.class);

    public SchemaFileDumper(DumpParameter parameter) {
        super(parameter);
    }

    @Override
    public void syncTasksStateFinally() {
    }

    @Override
    public TaskContext dumpRecordAsync() {
        throw new UnsupportedOperationException("not implement");
    }

    @Override
    protected void prepareForRetry(List<AbstractDumpTask> persistTasks) {
        List<ObjectType> unfinishedSchemaTaskObjectTypes = persistTasks.stream().filter(e -> TaskState.SUCCESS != e.getTaskState() && e instanceof AbstractSchemaDumpTask).map(e -> ObjectType.valueOfName(e.getObjectType())).collect(Collectors.toList());
        if (unfinishedSchemaTaskObjectTypes.isEmpty()) {
            throw new NoTaskGeneratedException("All the schema dump task have already finished, no need to retry");
        }
        this.parameter.removeFinishedObjectTypes(unfinishedSchemaTaskObjectTypes);
    }

    @Override
    protected List<Set<String>> groupByConcurrentSpec(ObjectType objectType, Set<String> objectNames) {
        if (ObjectType.TABLE != objectType) {
            return Collections.singletonList(objectNames);
        }
        int groupCount = objectNames.size() / this.parameter.getThreads();
        int mod = objectNames.size() % this.parameter.getThreads();
        return Lists.partition(new ArrayList<String>(objectNames), (int)(mod == 0 ? groupCount : groupCount + 1)).stream().map(HashSet::new).collect(Collectors.toList());
    }

    @Override
    protected void preDumpTasksSubmitted(ObjectType objectType, List<AbstractSchemaDumpTask> dumpTasks) {
    }

    @Override
    protected void postDumpTasksSubmitted(ObjectType objectType, List<AbstractSchemaDumpTask> dumpTasks) {
    }

    @Override
    protected void postAllDumpTasksSubmitted(List<AbstractSchemaDumpTask> dumpTasks) {
        log.info("Start {} schema dump threads for {} dump tasks finished.", (Object)this.parameter.getThreads(), (Object)dumpTasks.size());
    }

    @Override
    protected Map<ObjectType, Set<String>> getToBeDumpedObjectType2ObjectNames() {
        return this.parameter.getWhiteListMap();
    }

    @Override
    protected DumpTaskGenerator<AbstractSchemaDumpTask> createDumpTaskGenerator(@NonNull ThreadPoolExecutor executor) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        return new SchemaDumpTaskGenerator(this.parameter);
    }

    @Override
    protected ExecutorService createDumpTaskThreadPool() {
        return new ThreadPoolExecutor(this.parameter.getThreads(), this.parameter.getThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new NamedThreadFactory("dump-schema-thread-"));
    }
}

