/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.assembler;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.Hint;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.TableRangeInfo;
import com.oceanbase.tools.loaddump.dumper.assembler.IStatementAssembler;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatementAssembler
implements IStatementAssembler {
    private static final Logger log = LoggerFactory.getLogger(AbstractStatementAssembler.class);
    protected final TableRangeInfo tableRangeInfo;
    protected final boolean sub2270;
    protected final long dataVersion;
    protected final transient DumpParameter parameter;

    protected AbstractStatementAssembler(DumpParameter parameter) {
        this(new TableRangeInfo(), parameter, -1L);
    }

    protected AbstractStatementAssembler(TableRangeInfo tableRangeInfo, DumpParameter parameter, long dataVersion) {
        this.parameter = parameter;
        this.tableRangeInfo = tableRangeInfo;
        this.dataVersion = dataVersion;
        this.sub2270 = !parameter.getDatabase().getServerMode().isPreviousV2270();
    }

    protected StringBuilder buildSelectPrefix() {
        String tableName = this.tableRangeInfo.getTableName();
        StringBuilder sb = new StringBuilder(256);
        sb.append("SELECT ");
        List<Hint> hints = this.findRequiredHints();
        if (CollectionUtils.isNotEmpty(hints)) {
            sb.append("/*+ ");
            sb.append(hints.stream().map(Hint::getHintStatement).collect(Collectors.joining(" , ")));
            sb.append(" */ ");
        }
        if (this.parameter.isDistinct()) {
            sb.append("distinct ");
        }
        sb.append(this.parameter.getDatabase().getTableInfo(tableName).getSelectColumns());
        return sb.append(" FROM ").append(this.parameter.getDatabase().getServerMode().wrapName(tableName));
    }

    private List<Hint> findRequiredHints() {
        ArrayList<Hint> hints = new ArrayList<Hint>(2);
        if (this.parameter.isSnapshot() && this.getDataVersion() > -1L) {
            hints.add(new Hint(Hint.HintTypes.FROZEN_VERSION, this.getDataVersion()));
        }
        if (this.parameter.isEnableHiddenPk()) {
            hints.add(new Hint(Hint.HintTypes.OPT_PARAM, "'hidden_column_visible', 'true'"));
        }
        return hints;
    }

    protected abstract ServerMode getServerMode();

    @Override
    public List<String> assembleQuerySql() {
        if (StringUtils.isNotEmpty(this.getParameter().getQuerySql())) {
            return Lists.newArrayList((Object[])new String[]{this.getParameter().getQuerySql()});
        }
        StringBuilder querySqlPrefix = new StringBuilder(256);
        querySqlPrefix.append((CharSequence)this.buildSelectPrefix());
        if (this.parameter.isLogicalDatabase()) {
            return Lists.newArrayList((Object[])new String[]{querySqlPrefix.toString()});
        }
        querySqlPrefix.append(this.getPartitionName());
        querySqlPrefix.append(this.getFlashbackClause());
        boolean hasWhereClause = StringUtils.isNotEmpty(this.parameter.getWhereClause());
        String whereClause = hasWhereClause ? this.parameter.getWhereClause().trim() : "";
        boolean hasPrimaryKey = this.tableRangeInfo.hasPrimary();
        if (!hasWhereClause && !hasPrimaryKey) {
            return Lists.newArrayList((Object[])new String[]{querySqlPrefix.toString()});
        }
        querySqlPrefix.append(" WHERE ");
        if (hasWhereClause && !hasPrimaryKey) {
            return Lists.newArrayList((Object[])new String[]{querySqlPrefix.append(whereClause).toString()});
        }
        ArrayList<String> querySqlList = new ArrayList<String>();
        for (StringBuilder placeHolders : this.tableRangeInfo.getPrimaryPlaceHolders(this.getServerMode())) {
            StringBuilder querySql = new StringBuilder().append((CharSequence)querySqlPrefix);
            if (hasWhereClause) {
                querySql.append((CharSequence)placeHolders).append(" AND ").append(whereClause);
            } else {
                querySql.append((CharSequence)placeHolders);
            }
            querySqlList.add(querySql.toString());
        }
        return querySqlList;
    }

    protected abstract CharSequence getPartitionName();

    protected abstract CharSequence getFlashbackClause();

    public TableRangeInfo getTableRangeInfo() {
        return this.tableRangeInfo;
    }

    public boolean isSub2270() {
        return this.sub2270;
    }

    public long getDataVersion() {
        return this.dataVersion;
    }

    public DumpParameter getParameter() {
        return this.parameter;
    }
}

