/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.assembler;

import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.TableRangeInfo;
import com.oceanbase.tools.loaddump.dumper.assembler.AbstractStatementAssembler;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObMySqlStatementAssembler
extends AbstractStatementAssembler {
    private static final Logger log = LoggerFactory.getLogger(ObMySqlStatementAssembler.class);

    public ObMySqlStatementAssembler(DumpParameter parameter) {
        super(parameter);
    }

    public ObMySqlStatementAssembler(TableRangeInfo tableRangeInfo, DumpParameter parameter, long dataVersion) {
        super(tableRangeInfo, parameter, dataVersion);
    }

    @Override
    protected ServerMode getServerMode() {
        return ServerMode.MYSQL;
    }

    @Override
    protected CharSequence getFlashbackClause() {
        String flashbackScn = this.parameter.getFlashbackScn();
        if (!this.parameter.isSnapshot() && this.sub2270 && StringUtils.isNotBlank(flashbackScn)) {
            return new StringBuilder(" AS OF SNAPSHOT ").append(flashbackScn);
        }
        return "";
    }

    @Override
    protected CharSequence getPartitionName() {
        return this.tableRangeInfo.isPartitioned() ? " partition(" + ServerMode.MYSQL.wrapName(this.tableRangeInfo.getPartitionName()) + ")" : "";
    }
}

