/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.merge;

import com.oceanbase.tools.loaddump.dumper.merge.FileMerger;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBlockSizeFileMerger<T>
implements FileMerger {
    private static final Logger log = LoggerFactory.getLogger(AbstractBlockSizeFileMerger.class);
    private final Map<String, FileWrittenInfo> path2WrittenInfo = new HashMap<String, FileWrittenInfo>();
    private final Long blockRows;
    private final Long blockSizeBytes;

    public AbstractBlockSizeFileMerger(Long blockSizeBytes, Long blockRows) {
        this.blockRows = blockRows == null || blockRows <= 0L ? Long.MAX_VALUE : blockRows;
        this.blockSizeBytes = blockSizeBytes == null || blockSizeBytes <= 0L ? Long.MAX_VALUE : blockSizeBytes;
    }

    @Override
    public void merge(@NonNull Supplier<String> toPathSupplier, @NonNull List<AbstractRollingFileWriterV2.FileMetaInfo> fromPaths) throws IOException {
        if (toPathSupplier == null) {
            throw new NullPointerException("toPathSupplier is marked non-null but is null");
        }
        if (fromPaths == null) {
            throw new NullPointerException("fromPaths is marked non-null but is null");
        }
        for (AbstractRollingFileWriterV2.FileMetaInfo fileMetaInfo : fromPaths) {
            String fromPath = fileMetaInfo.getFilePath();
            this.forEachDataBlock(fromPath, fileMetaInfo, dataBlock -> {
                String toPath = this.findCandidateFilePath((DataBlock<T>)dataBlock);
                if (toPath == null) {
                    toPath = this.onRollOver(fromPath, toPathSupplier);
                }
                try {
                    this.doWrite(fromPath, toPath, (DataBlock<T>)dataBlock);
                    FileWrittenInfo writtenInfo = this.path2WrittenInfo.get(toPath);
                    writtenInfo.writtenBlockRows.addAndGet(((DataBlock)dataBlock).rows);
                    writtenInfo.writtenBlockSizeBytes.addAndGet(((DataBlock)dataBlock).sizeBytes);
                }
                catch (Exception e) {
                    log.warn("Failed to merge, file={}", (Object)fromPath, (Object)e);
                    throw new IllegalStateException(e);
                }
            });
        }
    }

    @Override
    public List<String> getToPaths() {
        return new ArrayList<String>(this.path2WrittenInfo.keySet());
    }

    private String findCandidateFilePath(DataBlock<T> dataBlock) {
        return this.path2WrittenInfo.entrySet().stream().filter(entry -> {
            FileWrittenInfo writtenInfo = (FileWrittenInfo)entry.getValue();
            return writtenInfo.writtenBlockRows.get() + ((DataBlock)dataBlock).rows < this.blockRows && writtenInfo.writtenBlockSizeBytes.get() + ((DataBlock)dataBlock).sizeBytes < this.blockSizeBytes;
        }).map(Map.Entry::getKey).findAny().orElse(null);
    }

    protected String onRollOver(String fromPath, Supplier<String> toPathSupplier) {
        String toPath = toPathSupplier.get();
        this.path2WrittenInfo.put(toPath, new FileWrittenInfo(new AtomicLong(0L), new AtomicLong(0L)));
        try {
            this.doOnRollOver(fromPath, toPath);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return toPath;
    }

    protected abstract void doWrite(String var1, String var2, DataBlock<T> var3) throws IOException;

    protected abstract void doOnRollOver(String var1, String var2) throws Exception;

    protected abstract void forEachDataBlock(String var1, AbstractRollingFileWriterV2.FileMetaInfo var2, Consumer<DataBlock<T>> var3);

    private static class FileWrittenInfo {
        private final AtomicLong writtenBlockRows;
        private final AtomicLong writtenBlockSizeBytes;

        public FileWrittenInfo(AtomicLong writtenBlockRows, AtomicLong writtenBlockSizeBytes) {
            this.writtenBlockRows = writtenBlockRows;
            this.writtenBlockSizeBytes = writtenBlockSizeBytes;
        }
    }

    protected static class DataBlock<T> {
        private final T data;
        private final Long rows;
        private final Long sizeBytes;

        public T getData() {
            return this.data;
        }

        public Long getRows() {
            return this.rows;
        }

        public Long getSizeBytes() {
            return this.sizeBytes;
        }

        public DataBlock(T data, Long rows, Long sizeBytes) {
            this.data = data;
            this.rows = rows;
            this.sizeBytes = sizeBytes;
        }
    }
}

