/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.merge;

import com.oceanbase.tools.loaddump.dumper.merge.AbstractBlockSizeFileMerger;
import com.oceanbase.tools.loaddump.dumper.merge.FlatFileMerger;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;

public class CsvFileMerger
extends FlatFileMerger {
    private String csvHeader;
    private final String fileEncoding;
    private final Map<String, Boolean> path2HeaderWritten = new HashMap<String, Boolean>();

    public CsvFileMerger(String fileEncoding, Long blockSizeBytes, Long blockRow) {
        super(blockSizeBytes, blockRow);
        this.fileEncoding = fileEncoding;
    }

    @Override
    public void merge(@NonNull Supplier<String> toPathSupplier, @NonNull List<AbstractRollingFileWriterV2.FileMetaInfo> fromFilePaths) throws IOException {
        if (toPathSupplier == null) {
            throw new NullPointerException("toPathSupplier is marked non-null but is null");
        }
        if (fromFilePaths == null) {
            throw new NullPointerException("fromFilePaths is marked non-null but is null");
        }
        fromFilePaths.forEach(fileMetaInfo -> {
            this.csvHeader = fileMetaInfo.getCsvHeader();
        });
        super.merge(toPathSupplier, fromFilePaths);
    }

    @Override
    protected void doWrite(String fromPath, String toPath, AbstractBlockSizeFileMerger.DataBlock<FileChannel> dataBlock) throws IOException {
        if (this.csvHeader != null) {
            FileChannel channel = dataBlock.getData();
            byte[] data = this.csvHeader.getBytes(this.fileEncoding);
            channel.position(channel.position() + (long)data.length);
            this.writeCsvHeader(toPath);
        }
        super.doWrite(fromPath, toPath, dataBlock);
    }

    @Override
    protected void doOnRollOver(String fromPath, String toPath) throws Exception {
        super.doOnRollOver(fromPath, toPath);
        this.writeCsvHeader(toPath);
    }

    private void writeCsvHeader(String toPath) throws IOException {
        if (this.csvHeader == null) {
            return;
        }
        byte[] data = this.csvHeader.getBytes(this.fileEncoding);
        FlatFileMerger.OutputStreamWrapper wrapper = (FlatFileMerger.OutputStreamWrapper)this.path2OutputStream.get(toPath);
        if (wrapper == null || wrapper.outputPos != 0L || Boolean.TRUE.equals(this.path2HeaderWritten.get(toPath))) {
            return;
        }
        wrapper.outputPos = data.length;
        IOUtils.write((byte[])data, (OutputStream)wrapper.outputStream);
        this.path2HeaderWritten.put(toPath, true);
    }
}

