/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.merge;

import com.oceanbase.tools.loaddump.dumper.merge.AbstractBlockSizeFileMerger;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatFileMerger
extends AbstractBlockSizeFileMerger<FileChannel> {
    private static final Logger log = LoggerFactory.getLogger(FlatFileMerger.class);
    protected final Map<String, OutputStreamWrapper> path2OutputStream = new HashMap<String, OutputStreamWrapper>();

    public FlatFileMerger(Long blockSizeBytes, Long blockRow) {
        super(blockSizeBytes, blockRow);
    }

    @Override
    protected void forEachDataBlock(String fromPath, AbstractRollingFileWriterV2.FileMetaInfo fileMetaInfo, Consumer<AbstractBlockSizeFileMerger.DataBlock<FileChannel>> consumer) {
        try (FileInputStream in = new FileInputStream(fromPath);
             FileChannel fromChannel = in.getChannel();){
            consumer.accept(new AbstractBlockSizeFileMerger.DataBlock<FileChannel>(fromChannel, fileMetaInfo.getRows(), fileMetaInfo.getSizeBytes()));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void doOnRollOver(String fromPath, String toPath) throws Exception {
        this.path2OutputStream.put(toPath, new OutputStreamWrapper(0L, new FileOutputStream(toPath, true)));
    }

    @Override
    protected void doWrite(String fromPath, String toPath, AbstractBlockSizeFileMerger.DataBlock<FileChannel> dataBlock) throws IOException {
        FileChannel channel = dataBlock.getData();
        OutputStreamWrapper wrapper = this.path2OutputStream.get(toPath);
        if (wrapper == null) {
            throw new IllegalStateException("Failed to find output stream by path, " + toPath);
        }
        wrapper.outputPos += wrapper.outputStream.getChannel().transferFrom(channel, wrapper.outputPos, channel.size());
    }

    @Override
    public void close() throws Exception {
        this.path2OutputStream.values().forEach(item -> {
            try {
                item.outputStream.close();
            }
            catch (Exception e) {
                log.warn("Failed to close the stream", (Throwable)e);
            }
        });
    }

    protected static class OutputStreamWrapper {
        protected long outputPos;
        protected final FileOutputStream outputStream;

        public OutputStreamWrapper(long outputPos, FileOutputStream outputStream) {
            this.outputPos = outputPos;
            this.outputStream = outputStream;
        }
    }
}

